#include "mbed.h"
//include PRPC command file
#include "SerialRPCInterface.h"
//LCD include
#include "TextLCD.h"

SerialRPCInterface SerieleInterface(USBTX, USBRX);
Serial uart(p9, p10); //tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut Pulsout(p28);
DigitalOut Transmit(p8);
AnalogIn Signaalsterkte(p19);
AnalogIn LDRin(p20);
DigitalIn Modepin(p11);
PwmOut PWMLed(p21);
TextLCD lcd(p30, p29, p28, p27, p26, p25, TextLCD::LCD20x4); // rs, e, d4-d7

char Mode;
float signaal;
int LDR;
char dataRX;
char crcRX;
char adresRX;
int dataOK;
int counter;
int sturen;
char adresTX;
char dataTX;
char crcTX;
int PWMLabview;
int timer;


RPCVariable<int> rpc_LDR(&LDR,"LDR");
RPCVariable<float> rpc_signaal(&signaal,"signaal");
RPCVariable<int> rpc_PWMLabview(&PWMLabview,"PWMLabview");

//Prototypes functies
char receive (char adreskarakter);
void transmit(char adresTX, char dataTX);

//********************************************
//*******************Main*********************
//********************************************
int main() 
{  
    PWMLed.period_us(10);
    uart.baud(4800); 
    if (Modepin)
    {
        myled1 = 1;
        myled2 = 0;
        Mode = 1; 
    }
    else
    {
        myled1 = 0;
        myled2 = 1;
        Mode = 0;     
    }
    lcd.cls(); 
    timer = 1000;
    while (1) 
    {
          //Pin aan GND is Labview
        if(Mode == 1)
        {
            transmit('J',LDRin * 255);
        }
        else //Labview
        {
            signaal = (Signaalsterkte * 207);
            if(signaal >= 100)
            {
                signaal = 100;    
            }
            LDR = receive('J');
            
            if(timer == 1000)
            {
                lcd.locate(0,0);
                lcd.printf("Signaal: %.0f%c",signaal, 37);
                lcd.locate(0,1);
                lcd.printf("LDR: %i ",LDR);
                timer = 0;
            }
            timer ++;
        }          
    }     
}

char receive (char adreskarakter)
{ 
        if(uart.readable()) {
            if (counter == 0)
            {
               adresRX = (uart.getc()); 
               
               if(adresRX == adreskarakter)
               {
               counter ++;
               }
               else
               {
                   counter = 0;
               }
               
            }
            else if (counter == 1)
            {
                dataRX = (uart.getc()); 
                counter ++;
            }
             else if (counter == 2)
            {
                crcRX = (uart.getc()); 
                counter = 0;
            }
           
           if(adresRX == adreskarakter && (adresRX xor dataRX) == crcRX)
           {
               dataOK = int(dataRX);
           }                    
        }   
        return dataOK; 
}

void transmit(char adresTX, char dataTX)
{
        Transmit = 1;
        
        crcTX = (adresTX xor dataTX);
        uart.printf("%c%c%c", adresTX, dataTX, crcTX);     

        Transmit = 0;  
}
