#include "mbed.h"
#include "SerialRPCInterface.h"
#include "LM75B.h"
#include "MMA7660.h"
#include <string>

#include "C12832_lcd.h"
#include "Arial_9.h"
#include "Small_7.h"
#include "graphics.h"
SerialRPCInterface SerialInterface(USBTX, USBRX);
float ai1=0;
float ai2=0;
int alarm1 = 0;
int alarm2 = 0;
float temp = 0;
int text;
float period;
int position;

float X = 0;
float Y = 0;
float Z = 0;

Serial pc(USBTX, USBRX);
RPCVariable<float> rpc_ai1(&ai1,"ai1");

RPCVariable<float> rpc_ai2(&ai2,"ai2");
 
RPCVariable<int> rpc_alarm1(&alarm1,"alarm1");
RPCVariable<int> rpc_alarm2(&alarm2,"alarm2");
RPCVariable<float> rpc_temp(&temp,"temp");
RPCVariable<int> rpc_text(&text,"text");
RPCVariable<float> rpc_period(&period,"period");
RPCVariable<int> rpc_position(&position,"position");

RPCVariable<float> rpc_X(&X,"X");
RPCVariable<float> rpc_Y(&Y,"Y");
RPCVariable<float> rpc_Z(&Z,"Z");

AnalogIn pot2(p19);
DigitalOut led(LED1);
AnalogIn pot1(p20);
DigitalOut led2(LED2);
LM75B tmp(p28,p27);
C12832_LCD lcd;
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);
PwmOut spkr(p26);
PwmOut servo(p21);
MMA7660 MMA(p28, p27);


void Welkom(void);
 
int main() {
    //Labview
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<SPI>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();
    
    char buf[256], outbuf[256];
    
   
 lcd.cls();
    //update axis period
    r.period(0.001); 
    Welkom();
    wait(2);
    lcd.cls();
    
    while (1){
    
        pc.gets(buf,256);
        rpc(buf,outbuf);
        pc.printf("%s\n",outbuf);
        
       temp = tmp.read() - 2;
        
        lcd.cls();
        lcd.locate(0,15);
        lcd.printf(" Nummer: %d",text);
        lcd.copy_to_lcd();
        
        
        
        ai1 = pot2;
        ai2 = pot1;
        if(pot2 > 0.3) {
            led = 1;
            alarm1 = led;
        } else {
            led = 0;
            alarm1 = led;
        }
        if(pot1 > 0.7) {
            led2 = 1;
            alarm2 = led2;
        } else {
            led2 = 0;
            alarm2 = led2;
        }  
        
        X = MMA.x();
        Y = MMA.y();
        Z = MMA.z();   
      //------------------------
        spkr.period(period /100000);
        spkr=0.5;
    
        servo.period_ms(20);
        servo=((position) * 0.000511 + 0.026);
        
       
    }
}

void Welkom(void)
{
  int i,s;
    lcd.cls();
    lcd.set_font((unsigned char*) Arial_9);
    s = 3;
    lcd.print_bm(bitmTree,95,0);  // print chistmas tree
    lcd.copy_to_lcd(); 
    lcd.setmode(XOR);             // XOR - a second print will erase  
    for(i = -15; i < 75; ){     
        lcd.print_bm(bitmSan1,i,2);
        wait(0.1);
        lcd.copy_to_lcd();           // update lcd  
        lcd.print_bm(bitmSan1,i,2);  // erase
        i= i+s;
        lcd.print_bm(bitmSan2,i,2);  // print next
        wait(0.1);
        lcd.copy_to_lcd();           // update lcd   
        lcd.print_bm(bitmSan2,i,2);  // erase
        i= i+s;
        lcd.print_bm(bitmSan3,i,2);  // print next 
        wait(0.1);
        lcd.copy_to_lcd();           // update lcd
        lcd.print_bm(bitmSan3,i,2);  // erase
        i= i+s;
   }
   lcd.print_bm(bitmSan3,i,2);
   lcd.set_auto_up(0);
   for(i=-20; i<5; i++){             // scrolling text
     lcd.locate(5,i);
     lcd.printf("Welkom bij");
     lcd.locate(5,i+12);
     lcd.printf("Labview!!!");
     lcd.copy_to_lcd();
     lcd.locate(5,i);
     wait(0.2);
     lcd.printf("Welkom bij");
     lcd.locate(5,i+12);
     lcd.printf("Labview!!!");
     lcd.copy_to_lcd();
     i=i+1;
   }  
   lcd.locate(5,i);
   lcd.printf("Welkom bij");
   lcd.locate(5,i+12);
   lcd.printf("Labview!!!");
   lcd.copy_to_lcd();   
}