#include "mbed.h"

/** Brocket function
    Used to determine the end effector position depending on the joint angles
    @param q1 current position of joint 1 in radians
    @param q2 current position of joint 2 in radians
    @param x Output variable for the x position of the end effector
    @param y Output variable for the y position of the end effector
*/
void Brocket(float q1,float q2,float &x,float &y);

/** Jacobian Tansposed function
    Used to determine the joint torques depending on the Forces applied to the end effector
    @param q1 current position of joint 1 in radians
    @param q2 current position of joint 2 in radians
    @param Fsprx Force applied to the end effector in x direction
    @param Fspry Force applied to the end effector in y direction
    @param tau1 Output variable for the Moment in joint1
    @param tau2 Output variable for the Moment in joint2
*/
void TransposeJacobian(float q1,float q2,float Fsprx,float Fspry,float &tau1,float &tau2);

/** Jacobian Tansposed function
    Used to determine the joint velocities depending on the end effector velocities
    @param q1 current position of joint 1 in radians
    @param q2 current position of joint 2 in radians
    @param vx Velocity of the end effector in x direction
    @param vy Velocity of the end effector in y direciton
    @param tau1 Output variable for the Moment in joint1
    @param tau2 Output variable for the Moment in joint2
*/
void InverseJacobian(float q1 , float q2, float vx, float vy, float &q1dot, float &q2dot);