#include "neopixel_i2c_daemon.h"
#include "strobe.h"
#define DEBUG_MODE 1
#include "log.h"
#include "neopixel.h"

DigitalOut myled(LED2);

Strobe::Strobe(NeoPixelI2cDaemon * deamon){
    freddy=deamon;
    SimplyLog::Log::i("6\r\n");
    state = SOFF;
    doExecute = false;    
}
void Strobe::execute(){
    
    if(doExecute){
        if(state==SON){
           SimplyLog::Log::i("4\r\n");
            neopixel::Pixel test;
            test.red = 255;
            test.green = 255;
            test.blue = 255;
            myled = !myled;
            freddy->allSingleColor(test);
           state=SOFF; 
            }
        else if(state==SOFF){
            SimplyLog::Log::i("9\r\n");
            freddy->allOff();
            SimplyLog::Log::i("10\r\n");
            state=SON;
            SimplyLog::Log::i("7\r\n");
            }
        doExecute=false;
        }
    }
void Strobe::isrTicker(){
    SimplyLog::Log::i("3\r\n");
    doExecute=true;
    }
void Strobe::strstart(){
    SimplyLog::Log::i("1\r\n");
    ticker.attach(this, &Strobe::isrTicker, 0.1);
    doExecute=false;
    state = SOFF;
    }
void Strobe::strstop(){
    SimplyLog::Log::i("2\r\n");
    ticker.detach();
    doExecute=false;
    state = SOFF;
    }