#pragma once
#include "i2c_device.h"
#include "neopixel_string.h"
#include <vector>
#include "strobe.h"
enum I2cCommand { OFF = 0x01, DIAGNOSTIC = 0x02, SINGLE_COLOR = 0x03, STROBO = 0x04 };
class Strobe;
class Licht;
class NeoPixelI2cDaemon {
    private:
        I2cDevice * i2c;
        std::vector<NeoPixelString *> pixelstrings;
        int cAlive;     // Counter for alive led
        DigitalOut alive;
        
    public:
        NeoPixelI2cDaemon(I2cDevice * i2c, PinName alive_pin);
        
    public:
        Strobe * hanzi;  
        void attachPixelString(NeoPixelString * pixelstring);
        void listen(bool blocking);
        void allOff(void);
        void allSingleColor(neopixel::Pixel singlecolor);
        void diagnoseAll(void);
};