#include "mbed.h"
#include "neopixel_string.h"
#include "i2c_device.h"
#include "neopixel_string_factory.h"
#include "neopixel_i2c_daemon.h"
#include "strobe.h"
 
// This must be an SPI MOSI pin.
#define DATA_PIN p5
#define STRING_SIZE 8
 
#define DEBUG_MODE 1
#include "log.h"
 
Serial pc(USBTX, USBRX); // tx, rx
 
int main() {
    pc.baud(115200);
    SimplyLog::Log::i("Neopixel driver loading\r\n");
    
    I2cSettings settings;
    settings.frequency = 100000;
    settings.address = 0x80;
 
    SimplyLog::Log::i("Slave is working @ %dHz\r\n", settings.frequency);
    SimplyLog::Log::i("Slave is working @ SLAVE_ADDRESS = 0x%x\r\n", settings.address);    
    
    SimplyLog::Log::i("Creating NeoPixel String\r\n");
    NeoPixelString * first_string = NeoPixelStringFactory::createNeoPixelString(DATA_PIN, STRING_SIZE);
    
    SimplyLog::Log::i("Creating I2cDevice\r\n");
    I2cDevice i2c(p28, p27, &settings);
    
    SimplyLog::Log::i("Creating NeoPixel I2c Daemon\r\n");
    NeoPixelI2cDaemon neo(&i2c, LED1);
    neo.attachPixelString(first_string);
 
    SimplyLog::Log::i("Listening in blocking mode\r\n");
    neo.listen(true);
    
    while(1) { }
}
 