#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn buttonred(PTD0);
InterruptIn buttonblue(PTD5);
DigitalOut ledred(LED_RED);
DigitalOut ledblue(LED_BLUE);

volatile int pressEventred = 0 ;
volatile int pressEventblue = 0 ;
volatile int red;
volatile int blue;
// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur
void buttonredCallback(){
    pressEventred = 1 ;
}
void buttonblueCallback(){
    pressEventblue = 1 ;
}
/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    buttonred.mode(PullUp);             // Ensure button i/p has pull up
    buttonred.fall(&buttonredCallback) ;   // Attach function to falling edge

    buttonblue.mode(PullUp);             // Ensure button i/p has pull up
    buttonblue.fall(&buttonblueCallback) ;   // Attach function to falling edge
    while(true) {
        // Toggle the LED every time the button is pressed
        if (pressEventred){
           red=!red;
           pressEventred = 0 ; // Clear the event variable
        }
        if (red==0){
           ledred = !ledred;
           }
        if (pressEventblue){
           blue=!blue;
           pressEventblue = 0 ; // Clear the event variable
        }
        if (blue==0){
           ledblue = !ledblue;
           }
        Thread::wait(500) ;
    }

}

