#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z,t;
        t=0.5;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
        Thread::wait(300);
        if ((x<-t)&&(abs(y)<t)&&(abs(z)<t)){
        pc.printf("left");
        }
        else if ((x>t)&&(abs(y)<t)&&(abs(z)<t)){
        pc.printf("right");
        }
        else if ((y<-t)&&(abs(x)<t)&&(abs(z)<t)){
        pc.printf("down");
        }
        else if ((y>t)&&(abs(x)<t)&&(abs(z)<t)){
        pc.printf("up");
        }
        else if (z>t){
        pc.printf("flat");
        }
        else if (z<-t){
        pc.printf("over");
        }
    }
}
