
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5

#include "mbed.h"


Ticker tick;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalOut lede1(PTD0);   // Red LED
DigitalOut lede2(PTD5) ; 
DigitalOut lede3(PTD2) ; 
DigitalOut lede4(PTD3) ;
DigitalOut lede5(PTD1) ;  
//InterruptIn button(PTD4);

Serial pc(USBTX, USBRX); // tx, rx, for debugging

DigitalIn b1(PTD4, PullUp);
Thread pollT ; // thread to poll
volatile int pressEvent=0;
enum buttonPos { up, down, bounce }; // Button positions // three options of button position

void polling() {
    buttonPos pos = up ;// initial position
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ; // action and update position
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down. what the default value of b1?- > it depends and doesnt have initial value
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(30);
    }
}
// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 




void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }       
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
   
    
    //led1 = 1 ; // turn off 
    int volts = 0 ;
    //const int threshold = 100 ;
    bool max_volts = false;
    bool detector = false;
    int counter = 0 ;
    int threshold[6] = {55,110,165,220,275,330};
    char vstring[] = "X.XX\r\n" ;
    pollT.start(callback(polling));


    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
        
        
        osEvent evt = mailbox.get(); // wait for mail    
        
         if (pressEvent) { // main event
            pressEvent = 0 ; // clear the event variable

            max_volts = !max_volts;
            detector = false;
        }
         
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
            
            if ((volts<=(threshold[0]))&&(max_volts==false))
            {
                
                lede1 = 0;
                lede2 = 0;
                lede3 = 0;
                lede4 = 0;
                lede5 = 0;
                
            }
          
           else if ((volts<=threshold[1])&&(volts>threshold[0])&&(max_volts==false))
            {
                
                lede1 = 1;
                lede2 = 0;
                lede3 = 0;
                lede4 = 0;
                lede5 = 0;
            }
            else if ((volts<=threshold[2])&&(volts>threshold[1])&&(max_volts==false))
                {
               
                lede1 = 1;
                lede2 = 1;
                lede3 = 0;
                lede4 = 0;
                lede5 = 0;
            }
            else if ((volts<=threshold[3])&&(volts>threshold[2])&&(max_volts==false))
                {
                
                lede1 = 1;
                lede2 = 1;
                lede3 = 1;
                lede4 = 0;
                lede5 = 0;
            }
             else if ((volts<=threshold[4])&&(volts>threshold[3])&&(max_volts==false))
            {
                
                lede1 = 1;
                lede2 = 1;
                lede3 = 1;
                lede4 = 1;
                lede5 = 0;
            }
               else if (((volts<=threshold[5])&&(volts>threshold[4]))||(max_volts==true))
            {
                
                lede1 = 1;
                lede2 = 1;
                lede3 = 1;
                lede4 = 1;
                lede5 = 1;
                if(volts >= threshold[4]){
                        
                         max_volts = false;
                    
                    }
            }
            
           
            
            
            
            
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }

    }
}
