#ifndef ARRAYQ_H
#define ARRAYQ_H

#include "mbed.h"
//---------------
//
//  Array queue class
//  for our EDP 2 project
//
//---------------
class ArrayQ {
    
    #define CAPACITY 100
    
    private:
        unsigned short *Q;
        int pFront, pRear, pSize, n;
        // pFront <- Front index of the queue
        // pRear  <- Rear index of the queue
        // pSize  <- Size of the queue
        // n      <- Capacity of the queue
    
    public:
        
        /**
        ** Constructors for the class
        **/
        ArrayQ();
        ArrayQ(int capacity);
        
        // Returns the actual size of the queue
        int size();
        
        // Checks if the queue is empty
        bool isEmpty();
        
        // Returns the front element of the queue without dequeue action
        unsigned short front();
        
        // Enqueues a value
        void enqueue(unsigned short value);
        
        // Dequeues the first element
        unsigned short dequeue();
        

};
#endif