/******************
    Has the actual implementation of the queue
******************/
#include "ArrayQueue.h"

ArrayQ::ArrayQ(){
    n = CAPACITY;
    Q = new unsigned short(n);
    pFront = 0;
    pRear = 0;
    pSize = 0; 
}

ArrayQ::ArrayQ(int capacity){
    n = capacity;
    Q = new unsigned short(n);
    pFront = 0;
    pRear = 0;
    pSize = 0;  
}
        
// Returns the actual size of the queue
int ArrayQ::size(){
    return pSize;
}
        
// Checks if the queue is empty
bool ArrayQ::isEmpty(){
    return pSize==0;
}    
        
// Returns the front element of the queue without dequeue action
unsigned short ArrayQ::front(){
    return Q[pFront];
}
        
// Enqueues a value
void ArrayQ::enqueue(unsigned short value){
    if(pSize!=n){
        Q[pRear] = value;
        pRear = (pRear+1)%n;
        pSize++;
    }
}

// Dequeues the first element
unsigned short ArrayQ::dequeue(){
    unsigned short dequeuedElement = NULL;
    
    if(!isEmpty()){
        dequeuedElement = Q[pFront];
        pFront = (pFront+1)%n;
        pSize--;
    }
    return dequeuedElement;
}