#ifndef _SIMInterface_H
#define _SIMInterface_H

#include "mbed.h"
#include "ATCommand.h"

/** An Interface for SIMCOM modules
 *
 * @brief Currently tested on SIM900, SIM800, SIM800L and SIM800F 
 *
 */

class SIMInterface
{

    protected:
    /** Serial port for UART Communication
     **/
        ATSerial sim800Interface;
        
    /** Digital pin to turn on and off
     **/
        DigitalOut PWRKEY;

    public:
    /** Create a SIMCOM Interface
     *
     *  @param tx Tx pin for the UART, rx RX pin for the UART, baudrate Baudrate for the UART, pwr PWRKEY pin of the SIM module
     *
     **/
        SIMInterface(PinName tx, PinName rx, int baudrate, PinName pwr);
        
    /** Function to wake up the SIM module
     **/
        void wakeUp();
        
    /** Function to reset the module
     **/
        void reset();
    
    /** Function to set the date on the module
     *
     *  @param Date is a char in the format "17/08/10,10:27:00+00"
     *
     **/
        void setDateRTC(char* Date);
        
    /** Function to get the date from the module
     **/
        char* getDateRTC();
    
    /** Function to turn the module off
     **/
        void turnOff();
    
    /** Function to check if the module is on
     *
     *  @param timeout is the time in ms that we will wait for the module to answer
     *
     **/
        int SIMOnOff(int timeout);
    
    private:
};

#endif

