#define _DEBUG 1

#if _DEBUG
//Enable debug
#define __DEBUG__
#include <cstdio>
#define DBG(x, ...) printf("[SIMInterface : DBG] "x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) printf("[SIMInterface : WARN] "x"\r\n", ##__VA_ARGS__);
#define ERR(x, ...) printf("[SIMInterface : ERR] "x"\r\n", ##__VA_ARGS__);

#else
//Disable debug
#define DBG(x, ...) 
#define WARN(x, ...)
#define ERR(x, ...) 
#endif

#include "SIMInterface.h"

char* responseInterface;

/** An Interface for SIMCOM modules
 *
 * @brief Currently tested on SIM900, SIM800, SIM800L and SIM800F 
 *
 */

SIMInterface::SIMInterface(PinName tx, PinName rx, int baudrate, PinName pwr) // ATSerial
: sim800Interface(tx, rx, baudrate), PWRKEY(pwr)
{
    
}

/** Function to check if the module is on
 *
 *  @param timeout is the time in ms that we will wait for the module to answer
 *
**/

int SIMInterface::SIMOnOff(int timeout)
{
    int count = 0;
    sim800Interface.sendCmd("AT\r\n");
    count = sim800Interface.getResponseLength(timeout);
    DBG("%d", count);
    if(count>0)
        return 1;
    else
        return 0;
}

/** Function to wake up the SIM module
**/

void SIMInterface::wakeUp()
{
    while(SIMOnOff(2000) == 0)
    { 
        PWRKEY = 0;
        wait_ms(1000);
        PWRKEY = 1;
        wait_ms(1000);
        PWRKEY = 0;
        wait_ms(2000);
    }
    sim800Interface.clearBuffer();
}

/** Function to reset the module
**/

void SIMInterface::reset()
{
    PWRKEY = 0;
    wait_ms(1000);
    PWRKEY = 1;
    wait_ms(1000);
    PWRKEY = 0;
    wait_ms(1000);
    
    wakeUp();
}

/** Function to set the date on the module
*
*  @param Date is a char in the format "17/08/10,10:27:00+00"
*
**/

void SIMInterface::setDateRTC(char* Date) // char* Date has to be in this format 17/07/28,19:59:00+00
{
    char  dateCmd [60];
    DBG("%s", Date);
    sprintf(dateCmd, "AT+CCLK=\"%s\"\r\n", Date);
    DBG("AT+CLTS=1");
    responseInterface = sim800Interface.sendCmdAndWaitForResp("AT+CLTS=1\r\n", 200);
    DBG("%s", responseInterface);
    DBG("AT+CCLK");
    responseInterface = sim800Interface.sendCmdAndWaitForResp(dateCmd, 1000);
    DBG("%s", responseInterface);
}

/** Function to get the date from the module
**/

char* SIMInterface::getDateRTC() 
{
    responseInterface = sim800Interface.sendCmdAndWaitForResp("AT+CCLK?\r\n", 80);
    DBG("%s", responseInterface);
    return responseInterface;
}

/** Function to turn the module off
**/

void SIMInterface::turnOff()
{
    if(SIMOnOff(2000) == 0)
    { 
      
    }else
    {
        PWRKEY = 0;
        wait_ms(1000);
        PWRKEY = 1;
        wait_ms(1000);
        PWRKEY = 0;
        wait_ms(1000);
    }
    sim800Interface.clearBuffer();
}


