#include "mbed.h"                 // mbed library
#include "HTTPSConnection.h"      // SIM800/SIM900 HTTPS library
#include "SIMInterface.h"         // SIM800/SIM900 interface
#include <string>                 // C string library 

#define SERIAL_TX PTC4            // SIM serial port TX pin
#define SERIAL_RX PTC3            // SIM serial port RX pin
#define SERIAL_BAUDRATE 19200     // SIM serial port baudrate
#define SIM_PWRKEY PTC6           // SIM PWRKEY pin 

char* POST_response;    // Response from Azure after a POST request
SIMInterface sim(SERIAL_TX,SERIAL_RX,SERIAL_BAUDRATE,SIM_PWRKEY);   // SIM Interface Definition
HTTPSConnection simHTTPS(SERIAL_TX,SERIAL_RX,SERIAL_BAUDRATE);      // SIM HTTPS Definition

// <apn>  A  string  parameter  to  indicate  the  GPRS  access  point  name.
// Ex: For VODAFONE ES it is "airtelwap.es"
static const char* gprs_apn = "";

// <URL>  A  string  parameter  to  indicate  the  connection URL.
// Ex: "https://XXXXXXXX.azure-devices.net/devices/XXXXX/messages/events?api-version=2016-02-03"
static const char* gprs_url = ""; 

// <SAS>  A  string  parameter  to  indicate  the  Shared Access Signature.
// Ex: "Authorization: SharedAccessSignature sr=XXXXX.azure-devices.net&sig=rCD5ZWvjblAl20djcEdtuL40vpKmdjvQH7lTphIRtJo%3D&se=1530094422"
static const char* gprs_sas = "";

// <SAS>  A  string  parameter  to  indicate  the  Shared Access Signature 
// Ex: "{\"temperature\":0.01123046875}\r\n"
char gprs_data [1000] = "";


// Main function
int main() 
{
    // Hello
    printf("Hola\r\n");
    
    // Wake up the module
    printf("Wake up, SIM!\r\n");
    sim.wakeUp();
    
    // Initializes HTTP and SSL on the module
    printf("Initializing HTTPS\r\n");
    simHTTPS.HTTPS_initialization(gprs_apn); 
    
    // Sets our Azure account parameters
    printf("Setting Azure IoT Hub Parameters\r\n");
    simHTTPS.HTTPS_setAzureParameters(gprs_url, gprs_sas, gprs_data); 
    
    // Infinite loop
    while (true)
    { 
        
        // HTTPS POST
        printf("HTTPS POST\r\n");
        POST_response = simHTTPS.HTTPS_post(10000);
        printf("%s\r\n", POST_response); 
        
        wait_ms(1000); // 1 second delay
        
    }
}