#ifndef _ATCommand_H
#define _ATCommand_H

#include "mbed.h"

/** A Serial interface for SIMCOM modules
 *
 * @brief Currently tested on SIM900, SIM800, SIM800L and SIM800F 
 *
 */

class ATSerial
{

protected:

    /** Serial port for UART Communication
     **/
    Serial _serial;

public:

  /** Create a Serial Interface for AT Commands
   *
   *  @param tx Tx pin for the UART
   *  @param rx RX pin for the UART
   *  @param baudrate Baudrate for the UART
   *
   **/
  ATSerial(PinName tx, PinName rx, int baudrate);
  
  /** Function to send a command to the SIM module
   *
   *  @param tx Tx pin for the UART
   *  @param rx RX pin for the UART
   *  @param baudrate Baudrate for the UART
   *
   **/
  void sendCmd(char *cmd);
  
  /** Function to check if we receive the string we want and returns if we have received it or not
   *
   *  @param cmd Command to send
   *  @param str String we want to receive
   *  @param len Length of the String we want
   *  @param timeout Time we wait for that string
   *
   **/
  int waitForAString(char* cmd, char* str,int len, int timeout);
  
  /** Function to wait for a string and store in the buffer what comes after that string
   *
   *  @param words String we are waiting for
   *  @param timeout Time we wait for that string
   *  @param buffer String where we store the string we want
   *
   **/
  int waitForWord(char* words, int timeout, char* buffer);
  
  /** Function to wait for the response
   *
   *  @param timeout Time we wait for the response
   *
   **/
  char* waitForResp(int timeout);
  
  /** Function to send a command and wait for the response
   *
   *  @param cmd Command to send
   *  @param timeout Time to wait for the response
   *
   **/
  char* sendCmdAndWaitForResp(char *cmd, int timeout);
  
  /** Function to get the length of a response
   *
   *  @param timeout Time to wait for the response
   *
   **/
  int getResponseLength(int timeout);
  
  /** Function to clear the buffer of the SIM module
   **/
  void clearBuffer();

private:
  
};

#endif