#include "ATCommand.h"
#include <cstring>
#include "iostream"
#include <string>

char *mybuffer;
Timer timeCnt;
int buffLen=0;

using std::memset;
using std::memcpy;
using namespace std;

/** Create a Serial Interface for AT Commands
 *
 *  @param tx Tx pin for the UART, rx RX pin for the UART, baudrate Baudrate for the UART
 *
**/

ATSerial::ATSerial(PinName tx, PinName rx, int baudrate)
:   _serial(tx,rx)
{
    _serial.baud(baudrate);
}

void ATSerial::sendCmd(char *cmd)
{
    _serial.puts(cmd);                                   //Sends the command contained by >cmd< to the sim900
    _serial.puts("\r\n");                                //Ads string "\r\n" --see ATProtocol
}

int ATSerial::waitForAString(char* cmd, char* str,int len, int timeout)
{
    sendCmd(cmd);
    timeCnt.reset();                                    //Reset the timer
    timeCnt.start();                                    //Start the timer
    int sum=0;
    char buf[100];
    char c;
    
    while(timeCnt.read_ms() <= timeout) 
    {
            if(_serial.readable()) 
            {
                c= _serial.getc();
                sum = (c==str[sum]) ? sum+1 : 0;        //Compare with the message >str< (input variable)
                if(sum == len)break;
            }
    }

    timeCnt.stop();
    timeCnt.reset();
    if(sum == len) //If the message matches, return ok
    {                     
        return 0;
    }
    return -1;

}


int ATSerial::waitForWord(char* words, int timeout, char* buffer)
{

    int len = 9;
    int sum=0;
    timeCnt.start();                                        //Start the timer
    int dd = 0;
    while(1) {                                              //First loop will look for the WORD
        if(_serial.readable()) { 
            char c = _serial.getc();
            sum = (c==words[sum]) ? sum+1 : 0;
            if(sum == len)break;
            dd++;
        }

        if(timeCnt.read_ms() > timeout) {                   // If timeout return ERROR
            timeCnt.stop();
            timeCnt.reset();
            buffLen=0;
            return -1;
        }
    }

    dd = 0;
    while(1) {                                              //Second bucle is to store the data in the buffer >mybuffer< until timeout
        if(_serial.readable()) {
            char c = _serial.getc();
            mybuffer[dd++] = c;
        }
        if(timeCnt.read_ms() > timeout) {                   // time out
            buffLen=dd;
            break;
        }
    }
    timeCnt.stop();                                         // stop timer
    timeCnt.reset();                                        // clear timer
    return 0;
}



char* ATSerial::waitForResp(int timeout)
{
    timeCnt.start();                                        // Start timer
    int co = 0;
    char resp [300];// = "                                                                                                                                                                                                                                                                                                           ";
    while(timeCnt.read_ms() < timeout) {                    // Read until timeout
        if(_serial.readable()) {                            // If there is data available
            char dd = _serial.getc();                       // Read serial port and save the data in a local buffer
            resp[co++] = dd;
        }
    }
    resp[co++] = '\0';                                      // Set end of string
    timeCnt.stop();                                         // Stop timer
    timeCnt.reset();                                        // Clear timer
    return resp;
}

char* ATSerial::sendCmdAndWaitForResp(char *cmd, int timeout)
{
    // Send command
    sendCmd(cmd);                                               //Sends the command in >cmd< to the sim900 
    return waitForResp(timeout);                                //Waits a >timeout< and reads from the serial, 
}

void ATSerial::clearBuffer()
{
    timeCnt.start();                                        // Start timer                                                                                                                                                                                                                                                                                                  ";
    while(timeCnt.read_ms() < 2000) {                    // Read until timeout
        if(_serial.readable()) {                             // If there is data available
        
        }
    }                                                     
    timeCnt.stop();                                         // Stop timer
    timeCnt.reset();                                        // Clear timer
    
}

int ATSerial::getResponseLength(int timeout)
{
    int dd=0;
    timeCnt.start();                                        // Start timer                                                                                                                                                                                                                                                          ";
    while(timeCnt.read_ms() < timeout) {                    // Read until timeout
        if(_serial.readable()) {                            // If there is data available                       
            dd++;
        }
    }
    timeCnt.stop();                                         // Stop timer
    timeCnt.reset();                                        // Clear timer
    return dd;
}