#include "mbed.h"
//#include "EthernetInterface.h"
#include "WIZ550ioInterface.h"
#include "NTPClient.h"

//EthernetInterface eth;
#if defined(TARGET_LPC1114)
SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
WIZ550ioInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
SPI spi(p11, p12, p13); // mosi, miso, sclk
WIZ550ioInterface eth(&spi, p14, p15); // spi, cs, reset

#elif defined(TARGET_LPC11U68)
SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
//WIZnetInterface eth(&spi, P0_2, P1_25); // spi, cs, reset
//SPI spi(p5, p6, p7); // mosi, miso, sclk
WIZ550ioInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io

#endif

NTPClient ntp;

int main() 
{
    //pc.baud(9600);
    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state
    
#ifdef _DHCP
    int ret = eth.init(); //Use DHCP
    if (!ret)
    {
      printf("Initialized, MAC: %s\n", eth.getMACAddress());
    }
    else
    {
      printf("Error eth.init() - ret = %d\n", ret);
      return -1;
    }

    ret = eth.connect();
    if (!ret)
    {
      printf("Connected, IP: %s, MASK: %s, GW: %s\n",
        eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }
    else
    {
      printf("Error eth.connect() - ret = %d\n", ret);
      return -1;
    }
#else
    uint32_t gw;
    uint32_t sn;
    uint32_t ip;

/*
    gw = 192;
    gw = (gw<<8) + 168;
    gw = (gw<<8) + 1;
    gw = (gw<<8) + 1;
    sn = 0xffffff00;
    ip = 192;
    ip = (ip<<8) + 168;
    ip = (ip<<8) + 1;
    ip = (ip<<8) + 212;
*/
    // for the NTP ex, i use real IP..
    gw = 222;
    gw = (gw<<8) + 98;
    gw = (gw<<8) + 173;
    gw = (gw<<8) + 254;
    sn = 0xffffffc0;
    ip = 222;
    ip = (ip<<8) + 98;
    ip = (ip<<8) + 173;
    ip = (ip<<8) + 212;
    
    int ret = eth.init(ip, sn, gw);
    if (!ret)
    {
      printf("Initialized, MAC: %s\n", eth.getMACAddress());
      printf("Connected, IP: %s, MASK: %s, GW: %s\n",
        eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    }
    else
    {
      printf("Error eth.init() - ret = %d\n", ret);
      return -1;
    }
#endif
   
    printf("Trying to update time...\r\n");
    
    // i don't use dns or something, so change to ipaddress
//    if (ntp.setTime("0.pool.ntp.org") == 0)
    if (ntp.setTime("61.110.197.50") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
    } 
   
    eth.disconnect();  

    while(1) {
    }
}
