#include "mbed.h"
#include "DS18B20Sensor.h"

DigitalOut myled(LED1);
Serial serial(USBTX, USBRX);
DS18B20Sensor sensor(P1_25);
// I set P1_25 here, but it's not affected code. (looked into library..no use this pinname)
// Instead of this line, please refer to define statment of "onewire.h".
// Thanks Steve Spence @ <<library /users/jsteve/code/DS18B20Sensor/>>

int main()
{
    uint8_t result;
    uint8_t i;
    char sensorBuf[25];

    serial.printf("Temperature Sensor DS18B20 Test.\rFound %d sensors\r", sensor.count());
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        result = sensor.startReading(true);     // start sensor readings and wait
        if (result == DS18X20_OK) {
            for (i = 0; i < sensor.count(); i++) {
                sensor.getReading(sensorBuf, i);         // get result into buf
                serial.printf("Sensor %d : %s\r", i+1, sensorBuf);  // display it to the world
            }
        } else {
            serial.printf("Sensor Reading Error (%d)\r", result);  // display it to the world

        }

    }
}
