/**    Hibernus Library
 *	   University of Southampton 2017
 *
 *		Open-source liberary that enable any of your Mbed project work with transient enegy sources.
 *		In order to use this library include the "hibernus.h" header file, and use the "Hibernus()" method at the beginning of you main funtion.
 *		For more details and example see the "main.cpp" exampe file, and the attached documnetation
 *
 *
 *     Released under the MIT License: http://mbed.org/license/mit
 */
#ifndef HIBERNUS_H_
#define HIBERNUS_H_

#define Fixed_Add_Vars_Offset 0x40			//the Offset added to the first address of RAM, in order to compute the address of first fixed Add variable
#define Fixed_Add_Vars_Size 0x2C					//size of the all fixed address variables (0x28 = 44(dec) = 4Bytes*(4 flags+3CoreReg+4LoopVar))
#define flash_end  (FLASH_Start + flash_Size)
#define ramToFlash_sectors_number (RAM_Size / sector_Size)		//how many flash sectors do we have to erase, before saving the RAM content to flash
#define flash_ramSection_start (flash_end - RAM_Size)

// Declare register integers for the SP, LR, and PC
register volatile unsigned int _SP __asm("r13");
register volatile unsigned int _LR __asm("r14");
register volatile unsigned int _PC __asm("r15");

// Value written to non-volatile flags to indicate that they are set or not
#define Flag_set 0xFFFF0000
#define Flag_erase  0xFFFFFFFF

// Declare external assembly language function (in a *.s file)
extern "C" void asm_restore(void);
extern "C" volatile unsigned int* getFlag_1(void);
extern "C" volatile unsigned int* getFlag_2(void);
extern "C" volatile unsigned int* getFlag_3(void);
extern "C" volatile unsigned int* getFlag_4(void);
extern "C" volatile unsigned int* getCore_SP(void);
extern "C" volatile unsigned int* getCore_LR(void);
extern "C" volatile unsigned int* getCore_PC(void);

void Hibernus(void);
void Save_RAM_Regs(void);
void Restore_Regs(void);
void restore(void);
void hibernate(void);

#endif
