/**    Hibernus Library
 *	   University of Southampton 2017
 *
 *		Open-source liberary that enable any of your Mbed project work with transient enegy sources.
 *		In order to use this library include the "hibernus.h" header file, and use the "Hibernus()" method at the beginning of you main funtion.
 *		For more details and example see the "main.cpp" exampe file, and the attached documnetation
 *
 *
 *     Released under the MIT License: http://mbed.org/license/mit
 */
 
#include "hibernus.h"
#include "mbed.h"
#include "config.h"

//11 variables stored at fixed addresses at the beginning of the RAM
volatile unsigned int FLAG_1 __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset))) = Flash_Flags_Sector_Start;
volatile unsigned int FLAG_2 __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+ 0x4))) = Flash_Flags_Sector_Start + 0x4;
volatile unsigned int FLAG_3 __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+ 0x8))) = Flash_Flags_Sector_Start + 0x8;
volatile unsigned int FLAG_4 __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+ 0xC))) = Flash_Flags_Sector_Start + 0xC;

volatile unsigned int CoreReg_SP __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x10)));
volatile unsigned int CoreReg_LR __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x14)));
volatile unsigned int CoreReg_PC __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x18)));
volatile unsigned int  n __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x1C)));   // Variable used for counting in loops (4 bytes) stored at RAM address (RamStart+0x54)
volatile unsigned char i __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x20)));   // Variable used for counting in loops (1 byte) stored at RAM address (RamStart+0x58)

volatile unsigned int *FLASH_ptr_4B __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x24)));    // Pointer that points to flash (4 bytes) stored at RAM address (RamStart+0x5C)
volatile unsigned int *RAM_ptr      __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x28)));    // Pointer that points to RAM (4 bytes) stored at RAM address (RamStart+0x60)

// Arrays used to store the contents of the peripheral registers
volatile unsigned int REG_Array_4B[No_Of_4B_Peripheral_Reg] 	__attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x2C)));;			
volatile unsigned char REG_Array_1B[No_Of_1B_Peripheral_Reg] __attribute__((at(RAM_1_Address+Fixed_Add_Vars_Offset+0x2C+4*No_Of_4B_Peripheral_Reg)));;

Serial pc1(USBTX, USBRX);
void Hibernus(){
	#if SaveFlagsInFlash == 0
		restore_flags();
	#endif
	
	if( isFlagSet(&FLAG_2) && isFlagSet(&FLAG_3) && isFlagSet(&FLAG_4))  // Enter this only after complete shut down
  {	
		erase_flags_memory();	
		setFlag(&FLAG_1);
		setFlag(&FLAG_4);
   }
		
	if(isFlagSet(&FLAG_1)||isFlagSet(&FLAG_2)||isFlagSet(&FLAG_3)||isFlagSet(&FLAG_4))
	{	
    __enable_irq();     // Enable interrupts
    Enter_LLS();        // Enter LLS mode
  }
		
	if(!isFlagSet(&FLAG_1)) // If *FLAG_1 is not already set (first time waking up)
  {
		erase_flags_memory();
		setFlag(&FLAG_2);
			
		#if HasInternalComparator == 1
				configure_VH_comparator_interrupt();
		#else
				configure_VH_gpio_interrupt();
		#endif
    __enable_irq();     // Enable interrupts
  }
  else{
		if(isFlagSet(&FLAG_4))
		{ 
		#if HasInternalComparator == 1
				configure_VH_comparator_interrupt();
		#else
				configure_VH_gpio_interrupt();
		#endif
			
			erase_flags_memory();
			setFlag(&FLAG_2);
			restore();
     }
  }
}

void Save_RAM_Regs(){  
	//Copy the peripheral registers to RAM
	for(n=0; n<No_Of_4B_Peripheral_Reg;n++){
		REG_Array_4B[n] = *(unsigned int*)REG_Addresses_4B[n];
	}
	for(n=0; n<No_Of_1B_Peripheral_Reg;n++){
		REG_Array_1B[n] = *(unsigned int*)REG_Addresses_1B[n];
	}
	
	//copy all the ram to flash
	copyRamToFlash();
}

void Restore_Regs(){ 
    //Restore peripheral registers from RAM, After the ram content was copied back from flash, after a restore
    for(n=0; n<No_Of_4B_Peripheral_Reg; n++){
        *(unsigned int*) REG_Addresses_4B[n] = REG_Array_4B[n];
    }
    
    for(i=0; i<No_Of_1B_Peripheral_Reg; i++){
        *(unsigned char*) REG_Addresses_1B[i] = REG_Array_1B[i];
    }
}

void restore(){
	// Restore procedure
	__disable_irq();     // Disable interrupts
 
	erase_flags_memory();
	setFlag(&FLAG_2); 

	//Restore peripheral registers	
	Restore_Regs();     
                
	//Restore RAM
  FLASH_ptr_4B = (unsigned int*) (flash_ramSection_start);       
  RAM_ptr      = (unsigned int*) (RAM_1_Address);
	
	//Copy RAM until where the pointers and loop variables are stored
	//divide it by 4 because the copy is done word by word but byte by byte
  for(n=0; n<(Fixed_Add_Vars_Offset/4); n++){                                
		*(RAM_ptr + n) = *(FLASH_ptr_4B + n);
	}
	
	//skip the Core reg and fixed address variables
	FLASH_ptr_4B = (unsigned int*)(flash_ramSection_start +Fixed_Add_Vars_Offset+ Fixed_Add_Vars_Size);
	RAM_ptr = (unsigned int*)(RAM_1_Address +Fixed_Add_Vars_Offset+ Fixed_Add_Vars_Size);
	
	//copy the rest of the RAM
	//(RAM_Size-Fixed_Add_Vars_Offset-Fixed_Add_Vars_Size) is the siz eof the rest of the ram that have to be copied
	//divide it by 4 because the copy is done word by word but byte by byte
	 for(n=0; n<(RAM_Size-Fixed_Add_Vars_Offset-Fixed_Add_Vars_Size)/4; n++){                                
		*(RAM_ptr + n) = *(FLASH_ptr_4B + n);
  }
	 
	//copy the 3 core registers from flash o ram
	CoreReg_SP=*(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset+0x10);
	CoreReg_LR=*(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset+0x14);
	CoreReg_PC=*(unsigned int*)(flash_ramSection_start+Fixed_Add_Vars_Offset+0x18);
								
	//Configure the iterrupt for VH/Hibernate
	#if HasInternalComparator == 1
			configure_VH_comparator_interrupt();
	#else
			configure_VH_gpio_interrupt();
	#endif
		
	__enable_irq();     // Enable interrupts 

	asm_restore();      	// Restore the value of SP                        
	_LR = CoreReg_LR;     // Restore the value of LR
  _PC = CoreReg_PC;     // Restore the value of PC
}

extern "C" volatile unsigned int* getFlag_1(){
	return &FLAG_1;
}

extern "C" volatile unsigned int* getFlag_2(){
	return &FLAG_2;
}

extern "C" volatile unsigned int* getFlag_3(){
	return &FLAG_3;
}

extern "C" volatile unsigned int* getFlag_4(){
	return &FLAG_4;
}

extern "C" volatile unsigned int* getCore_SP(){
	return &CoreReg_SP;
}

extern "C" volatile unsigned int* getCore_PC(){
	return &CoreReg_PC;
}

extern "C" volatile unsigned int* getCore_LR(){
	return &CoreReg_LR;
}
