/**
 * @file TestingState.h
 * @brief The header file for the TestingState class.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef TESTING_STATE_H
#define TESTING_STATE_H

#include <mbed.h>
#include "States.h"

/**
 * @class TestingState
 * @brief The class for testing state. It is a child class of the States class.
 * 
 */
class TestingState : public States
{
public:
    /**
    * @brief This is the constructor for the TestingState class
    */
    TestingState();
    /**
    * @brief This is the destructor for the TestingState class
    */
    ~TestingState();
    
    /**
    * @brief Draw the user interface. This function is called only once, whenever the testing state becomes the current state.
    */
    virtual void DrawUserInterface();
    
    /**
    * @brief This functino will be called during every tick, only if the testing state is the current state. 
    * @param deltaTime The time interval between last tick and current tick.
    */
    virtual void Update(float deltaTime);
    
    /**
    * @brief Return wether or not the testing state has a position callback function for the touch screen.
    * @return 0 for not, 1 for yes.
    */
    virtual uint8_t HasTouchPosFunction() const;
    
    /**
    * @brief Return wether or not the testing state has a interrupt callback function for the touch screen.
    * @return 0 for not, 1 for yes.
    */
    virtual uint8_t HasTouchIrqFunction() const;
    
    /**
    * @brief The interrupt callback function for the touch screen.
    */
    virtual void TouchIrqCallback();
    
private:
    volatile uint8_t m_shouldTerminate; /*!< @brief Did testing state received a pendding Terminating command? */
};

#endif //TESTING_STATE_H