/**
 * @file States.h
 * @brief The header file for the States class.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
 
#pragma once
#ifndef STATES_H
#define STATES_H

#include <mbed.h>
/**
 * @class States
 * @brief The abstract class for different states. This class should not be used directly.
 * 
 */
class States
{
public:
    /**
    * @brief This is the constructor for the States class
    * 
    */
    States(){}
    /**
    * @brief This is the destructor for the States class
    * 
    */
    ~States(){}
    
    /**
    * @brief This function will be called once, when this instance becoming the current state.
    * 
    */
    virtual void DrawUserInterface(){}
    
    /**
    * @brief This functino will be called during every tick, only if this instance is the current state.
    * @param deltaTime The time interval between last tick and current tick.
    * 
    */
    virtual void Update(float deltaTime){}
    
    /**
    * @brief Return wether or not this State has a position callback function for the touch screen.
    * @return 0 for not, 1 for yes.
    * 
    */
    virtual uint8_t HasTouchPosFunction() const{return 0;}
    
    /**
    * @brief Return wether or not this State has a interrupt callback function for the touch screen.
    * @return 0 for not, 1 for yes.
    * 
    */
    virtual uint8_t HasTouchIrqFunction() const{return 0;}
    
    /**
    * @brief This is the position callback function for the touch screen.
    * @param x The position on x axis.
    * @param y The position on y axis.
    * 
    */
    virtual void TouchPosCallback(int16_t x, int16_t y){}
    
    /**
    * @brief This is the interrupt callback function for the touch screen.
    * 
    */
    virtual void TouchIrqCallback(){}
};

#endif //STATES_H