/**
 * @file PinAssignment.h
 * @brief The header file for pin assignments. All of the assignment to the pins MUST happen here, so that we can make sure that there is no one single pin assigned to two (or more) functions.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef PIN_ASSIGNMENT_H
#define PIN_ASSIGNMENT_H



//LED Manager Class
#define PIN_LMC_LED_RED    LED_RED
#define PIN_LMC_LED_GREEN  LED_GREEN
//#define PIN_LMC_LED_BLUE   LED_BLUE //DO NOT use blue LED, otherwise, the SPI port will not work!

//Motor Class
#define PIN_MC_DIR_R       PTD4  /*!< @brief Motor driver direction, right. */
#define PIN_MC_SPEED_R     PTA12 /*!< @brief Motor driver speed (power) level, right. */

#define PIN_MC_DIR_L       PTA4  /*!< @brief Motor driver direction, left. */
#define PIN_MC_SPEED_L     PTA5  /*!< @brief Motor driver speed (power) level, left. */

//Servo
#define PIN_SC_SERVO       PTB3  /*!< @brief Servo, turn signal */

/*
//Camera Class
#define PIN_CC_PCLOCK      PTA17 
#define PIN_CC_HREF        PTD6
#define PIN_CC_VSYNC       PTD7

#define PIN_CC_D_0         PTB8
#define PIN_CC_D_1         PTB9
#define PIN_CC_D_2         PTB10
#define PIN_CC_D_3         PTB11
#define PIN_CC_D_4         PTE2
#define PIN_CC_D_5         PTE3
#define PIN_CC_D_6         PTE4
#define PIN_CC_D_7         PTE5
*/
//OVxxxx RegBuf Class
#define PIN_ORB_SDA        PTE0 /*!< @brief SCCB control to the camera, SDA line. */
#define PIN_ORB_SCL        PTE1 /*!< @brief SCCB control to the camera, SCL line. */

//Wheel Encoder Class
#define PIN_WE_RL          PTD5   /*!< @brief Wheel encoder, rear left, interrupt in. */
#define PIN_WE_RR          PTA13  /*!< @brief Wheel encoder, rear right, interrupt in. */

//ArduCam Class
#define PIN_ACC_CS         PTC12  /*!< @brief ArduCam Mini, chip select pin. */

//ArduUTFT Class
#define PIN_AUC_CS         PTC13  /*!< @brief ArduCam shield V2, chip select. */

//ArduTouch Class
#define PIN_ATC_TOUCH_CS   PTC16  /*!< @brief ArduCam shield V2 touch screen, chip select. */
#define PIN_ATC_TOUCH_IRQ  PTA16  /*!< @brief ArduCam shield V2 touch screen, interrupt in. */

//ArduSD Class (Not exsit yet)
#define PIN_AUC_SD_CS      PTC17  /*!< @brief ArduCam shield V2 SD reader, chip select. */

//IMU Manager Class
#define PIN_IMC_SDA        PTC9  /*!< @brief I2C connection to the IMU, SDA line. */
#define PIN_IMC_SCL        PTC8  /*!< @brief I2C connection to the IMU, SCL line. */
//#define PIN_IMC_SDA        PTE25
//#define PIN_IMC_SCL        PTE24

#define PIN_IMC_ACCL_SA0   PTB8  /*!< @brief IMU accelerometer slave address select 0. */
#define PIN_IMC_ACCL_SA1   PTB9  /*!< @brief IMU accelerometer slave address select 1. */

//////////////////////////////////////
//Global Ports
#define PIN_SPI_MOSI       PTD2  /*!< @brief MOSI pin for the SPI port. */
#define PIN_SPI_MISO       PTD3  /*!< @brief MISO pin for the SPI port. */
#define PIN_SPI_SCK        PTD1  /*!< @brief SCK pin for the SPI port. */



#endif