#include "ArduUTFT.h"

//#define SW_DEBUG
#include "GlobalVariable.h"

#include "ArduUTFTFont.h"

extern SPI g_spi_port;

#define UTFT_DISP_TRANS_MODE  8


#define swap(type, i, j) {type t = i; i = j; j = t;}


#ifdef __cplusplus
extern "C" {
#endif


static uint8_t * current_font = NULL;
static uint8_t font_x_size = 0;
static uint8_t font_y_size = 0;
static uint8_t font_offset = 0;
//static uint8_t font_numchars = 0;

static uint8_t front_color_high = 0;
static uint8_t front_color_low = 0;


static DigitalOut utft_cs(PIN_AUC_CS, 1);
static DigitalOut utft_sd_cs(PIN_AUC_SD_CS, 1);

inline void ardu_utft_spi_write_8(int address, int value)
{
    utft_cs = 0;
    g_spi_port.write(address | 0x80);
    g_spi_port.write(value);
    utft_cs = 1;
}

inline uint8_t ardu_utft_spi_read_8(int address)
{
    utft_cs = 0;
    g_spi_port.write(address & 0x7F);
    uint8_t value = static_cast<uint8_t>(g_spi_port.write(0x00));
    utft_cs = 1;

    return value;
}

inline void ardu_utft_write_COM_internal(uint8_t VL)  
{   
    utft_cs = 0;
    g_spi_port.write(0xBE);
    g_spi_port.write(VL);
    utft_cs = 1;
}
 
inline void ardu_utft_write_DATA_internal(uint8_t VH, uint8_t VL)
{
    utft_cs = 0;
    g_spi_port.write(0xBF);
    g_spi_port.write(VH);
    utft_cs = 1;
    utft_cs = 0;
    g_spi_port.write(0xBF);
    g_spi_port.write(VL);
    utft_cs = 1;

}

inline void ardu_utft_write_COM_DATA_internal(uint8_t com1, uint16_t dat1)
{
     ardu_utft_write_COM_internal(com1);
     ardu_utft_write_DATA_internal((dat1 >> 8) & 0xFF, dat1);
}

void ardu_utft_write_DATA(uint8_t VH, uint8_t VL)
{
    ardu_utft_write_DATA_internal(VH, VL);
}

void ardu_utft_init()
{
    uint8_t VerNum = ardu_utft_spi_read_8(ARDUCHIP_VER_UTFT);
    VerNum = ardu_utft_spi_read_8(ARDUCHIP_VER_UTFT);
    
    ardu_utft_spi_write_8(ARDUCHIP_TEST1_UTFT, ARDUCHIP_TEST_MSG_UTFT);
    uint8_t testV = ardu_utft_spi_read_8(ARDUCHIP_TEST1_UTFT);
    if(VerNum != ARDUCHIP_VER_NUM_UTFT || testV != ARDUCHIP_TEST_MSG_UTFT)
    {
        
    }
    else
    {
        
    }
    
    ardu_cam_set_mode(MCU2LCD_MODE);
    ardu_utft_write_COM_DATA_internal(0x00,0x0001);
    ardu_utft_write_COM_DATA_internal(0x03,0xA8A4);
    ardu_utft_write_COM_DATA_internal(0x0C,0x0000);
    ardu_utft_write_COM_DATA_internal(0x0D,0x080C);
    ardu_utft_write_COM_DATA_internal(0x0E,0x2B00);
    ardu_utft_write_COM_DATA_internal(0x1E,0x00B7);
    ardu_utft_write_COM_DATA_internal(0x01,0x6B3F); //693F
    ardu_utft_write_COM_DATA_internal(0x02,0x0600);
    ardu_utft_write_COM_DATA_internal(0x10,0x0000);
    ardu_utft_write_COM_DATA_internal(0x11,0x6078);
    ardu_utft_write_COM_DATA_internal(0x05,0x0000);
    ardu_utft_write_COM_DATA_internal(0x06,0x0000);
    ardu_utft_write_COM_DATA_internal(0x16,0xEF1C);
    ardu_utft_write_COM_DATA_internal(0x17,0x0003);
    ardu_utft_write_COM_DATA_internal(0x07,0x0233);
    ardu_utft_write_COM_DATA_internal(0x0B,0x0000);
    ardu_utft_write_COM_DATA_internal(0x0F,0x0000);
    ardu_utft_write_COM_DATA_internal(0x41,0x0000);
    ardu_utft_write_COM_DATA_internal(0x42,0x0000);
    ardu_utft_write_COM_DATA_internal(0x48,0x0000);
    ardu_utft_write_COM_DATA_internal(0x49,0x013F);
    ardu_utft_write_COM_DATA_internal(0x4A,0x0000);
    ardu_utft_write_COM_DATA_internal(0x4B,0x0000);
    ardu_utft_write_COM_DATA_internal(0x44,0xEF00);
    ardu_utft_write_COM_DATA_internal(0x45,0x0000);
    ardu_utft_write_COM_DATA_internal(0x46,0x013F);
    ardu_utft_write_COM_DATA_internal(0x30,0x0707);
    ardu_utft_write_COM_DATA_internal(0x31,0x0204);
    ardu_utft_write_COM_DATA_internal(0x32,0x0204);
    ardu_utft_write_COM_DATA_internal(0x33,0x0502);
    ardu_utft_write_COM_DATA_internal(0x34,0x0507);
    ardu_utft_write_COM_DATA_internal(0x35,0x0204);
    ardu_utft_write_COM_DATA_internal(0x36,0x0204);
    ardu_utft_write_COM_DATA_internal(0x37,0x0502);
    ardu_utft_write_COM_DATA_internal(0x3A,0x0302);
    ardu_utft_write_COM_DATA_internal(0x3B,0x0302);
    ardu_utft_write_COM_DATA_internal(0x23,0x0000);
    ardu_utft_write_COM_DATA_internal(0x24,0x0000);
    ardu_utft_write_COM_DATA_internal(0x25,0x8000);
    ardu_utft_write_COM_DATA_internal(0x4f,0x0000);
    ardu_utft_write_COM_DATA_internal(0x4e,0x0000);
    ardu_utft_write_COM_internal(0x22);
    
    ardu_utft_set_font(SmallFont);
    ardu_utft_clr_scr();
    
}

void ardu_cam_set_mode(uint8_t mode)
{
    ardu_utft_spi_write_8(ARDUCHIP_MODE, MCU2LCD_MODE);
}

void ardu_utft_clr_scr()
{
    ardu_utft_reset_xy();
 
    long i;
    for (i = 0; i < ((UTFT_DISP_X_SIZE + 1) * (UTFT_DISP_Y_SIZE + 1)); ++i)
    {
        ardu_utft_write_DATA_internal(0x00,0x00);
    }
}

void ardu_utft_reset_xy()
{
    ardu_utft_set_xy(0, 0, UTFT_DISP_Y_SIZE, UTFT_DISP_X_SIZE);
}

void ardu_utft_set_xy(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2)
{
    /////////////////////////////
    //Possible to be simplified
    swap(uint16_t, x1, y1);
    swap(uint16_t, x2, y2);
    //y1 = UTFT_DISP_Y_SIZE - y1; //319 - 0 = 319
    //y2 = UTFT_DISP_Y_SIZE - y2; //319 - 300 = 19
    //swap(uint16_t, y1, y2); //y1 = 19, y2 = 319
    /////////////////////////////
    
    ardu_utft_write_COM_DATA_internal(0x44, (x2 << 8) + x1);
    ardu_utft_write_COM_DATA_internal(0x45, UTFT_DISP_Y_SIZE - y2); //19
    ardu_utft_write_COM_DATA_internal(0x46, UTFT_DISP_Y_SIZE - y1); //319
    ardu_utft_write_COM_DATA_internal(0x4e, x1);
    ardu_utft_write_COM_DATA_internal(0x4f, UTFT_DISP_Y_SIZE - y2);
    ardu_utft_write_COM_internal(0x22);
}
 
void ardu_utft_set_color(uint8_t r, uint8_t g, uint8_t b)
{
    front_color_high = ((r & 248) | g >> 5);
    front_color_low = ((g & 28) << 3 | b >> 3);
}

void ardu_utft_draw_rect(int x1, int y1, int x2, int y2)
{
    if (x1>x2)
    {
        swap(int, x1, x2);
    }
    if (y1>y2)
    {
        swap(int, y1, y2);
    }
    
    ardu_utft_draw_hline(x1, y1, x2 - x1);
    ardu_utft_draw_hline(x1, y2, x2 - x1);
    ardu_utft_draw_vline(x1, y1, y2 - y1);
    ardu_utft_draw_vline(x2, y1, y2 - y1);
}

void ardu_utft_draw_hline(int x, int y, int l)
{
    if (l<0)
    {
        l = -l;
        x -= l;
    }
    
    ardu_utft_set_xy(x, y, x+l, y);
    
    for (int i = 0; i < l + 1; ++i)
    {
        ardu_utft_write_DATA_internal(front_color_high, front_color_low);
    }
    
    ardu_utft_reset_xy();
}

void ardu_utft_draw_vline(int x, int y, int l)
{
    if (l<0)
    {
        l = -l;
        y -= l;
    }
    
    ardu_utft_set_xy(x, y, x, y+l);
    
    for (int i = 0; i < l + 1; ++i)
    {
        ardu_utft_write_DATA_internal(front_color_high, front_color_low);
    }
    
    ardu_utft_reset_xy();
}

 
void ardu_utft_draw_pixel(int x, int y)
{
    ardu_utft_set_xy(x, y, x, y);
    ardu_utft_write_DATA_internal(front_color_high, front_color_low);
    ardu_utft_reset_xy();
}

void ardu_utft_fill_rect(int x1, int y1, int x2, int y2)
{
    if (x1 > x2)
    {
        swap(int, x1, x2);
    }
    if (y1 > y2)
    {
        swap(int, y1, y2);
    }
    
    for (int i = 0; i < ((x2 - x1) / 2) + 1; ++i)
    {
        ardu_utft_draw_vline(x1 + i, y1, y2 - y1);
        ardu_utft_draw_vline(x2 - i, y1, y2 - y1);
    }
}

void ardu_utft_set_font(uint8_t * font)
{
    current_font = font;
    font_x_size = font[0];
    font_y_size = font[1];
    font_offset = font[2];
    //font_numchars = font[3];
}

void ardu_utft_print_char(char c, int x, int y)
{
    char i, ch;
    
    uint16_t temp = ((c - font_offset) * ((font_x_size / 8) * font_y_size)) + 4;
    
    for(uint8_t j = 0; j < font_y_size; ++j) 
    {
        for (int zz = 0; zz < (font_x_size / 8); ++zz)
        {
            ch = current_font[temp + zz]; 
            for(i = 0; i < 8; ++i)
            {   
                ardu_utft_set_xy(x + i + (zz * 8), y + j, x + i + (zz * 8) + 1, y + j + 1);
            
                if((ch & (1 << i)) != 0)   
                {
                    ardu_utft_write_DATA_internal(front_color_high, front_color_low);
                }
                else
                {
                    ardu_utft_write_DATA_internal(0x00, 0x00);
                }
            }
        }
        temp += (font_x_size / 8);
    }
    
    ardu_utft_reset_xy();
}

void ardu_utft_print(char * st, int x, int y)
{
    int stl, i;
    stl = strlen(st);
    
    if (x == UTFT_RIGHT)
        x = (UTFT_DISP_Y_SIZE + 1) - (stl * font_x_size);
    if (x == UTFT_CENTER)
        x = ((UTFT_DISP_Y_SIZE + 1) - (stl * font_x_size)) / 2;

    for (i = 0; i < stl; ++i)
        ardu_utft_print_char(*st++, x - (i * (font_x_size)), y);
}

uint8_t ardu_utft_get_ver_num()
{
    return ardu_utft_spi_read_8(ARDUCHIP_VER_UTFT);
}

#ifdef __cplusplus
}
#endif