/**
 * @file StateManager.h
 * @brief The header file for the state manager.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef STATE_MANAGER_H
#define STATE_MANAGER_H

#include <mbed.h>

class States;

#define STANDBY_STATE 0  /*!< @brief Standby State. ENUM for different states. It is used as input for state_manager_switch_state. */
#define RUNNING_STATE 1  /*!< @brief Running State. ENUM for different states. It is used as input for state_manager_switch_state. */
#define TESTING_STATE 2  /*!< @brief Testing State. ENUM for different states. It is used as input for state_manager_switch_state. */

/**
* @brief This function will be called on each tick in order to tick the current state.
* @param deltaTime The time interval between last tick and current tick.
*/
void state_manager_update(float deltaTime);

/**
* @brief Switch the current state to a specific state. If the input is not valid, it will be switched to NULL state, which will do nothing.
* @param state The defined number that representing different states. Please refer to the definition above.
*/
void state_manager_switch_state(uint8_t state);

#endif //STATE_MANAGER_H