#include "StateManager.h"
#include "States.h"
#include "ArduTouch.h"

#include "ArduUTFT.h"

#include "StandbyState.h"
#include "RunningState.h"
#include "TestingState.h"


static States* stat_manger_curr_stat = NULL;

void state_manager_touch_pos(int16_t x, int16_t y)
{
    stat_manger_curr_stat->TouchPosCallback(x, y);
}

void state_manager_touch_irq()
{
    stat_manger_curr_stat->TouchIrqCallback();
}

void state_manager_set_current_state(States* stat)
{
    stat_manger_curr_stat = stat;
    if(stat_manger_curr_stat)
    {
        if(stat_manger_curr_stat->HasTouchPosFunction())
        {
            ardu_touch_set_pos_function(&state_manager_touch_pos);
        }
        
        if(stat_manger_curr_stat->HasTouchIrqFunction())
        {
            ardu_touch_set_irq_function(&state_manager_touch_irq);
        }
        
        stat_manger_curr_stat->DrawUserInterface();
    }
}

void state_manager_clear_current_state()
{
    if(stat_manger_curr_stat)
    {
        //delete stat_manger_curr_stat;
        stat_manger_curr_stat = NULL;
    }
    
    ardu_touch_set_irq_function(NULL);
    ardu_touch_set_pos_function(NULL);
}

void state_manager_update(float deltaTime)
{
    if(stat_manger_curr_stat)
    {
        stat_manger_curr_stat->Update(deltaTime);
    }
}

void state_manager_switch_state(uint8_t state)
{
    static StandbyState standby;
    static RunningState running;
    static TestingState testing;
    
    state_manager_clear_current_state();
    
    //ardu_utft_print("X", 20, 20);
    switch(state)
    {
    case STANDBY_STATE:
        state_manager_set_current_state(&standby);
        break;
    case RUNNING_STATE:
        state_manager_set_current_state(&running);
        break;
    case TESTING_STATE:
        state_manager_set_current_state(&testing);
        break;
    default:
        
        break;
    }
    //ardu_utft_print("X", 30, 30);
}
