#include "CamRegBuf.h"

#include "PinAssignment.h"

#include "CamRegDefinitions.h"

CamRegBuf::CamRegBuf(uint8_t writeAddr,  uint8_t readAddr) : 
    m_writeAddr(writeAddr),
    m_readAddr(readAddr),
    m_sccbCtrl(I2C(PIN_ORB_SDA, PIN_ORB_SCL))
{
    
}

CamRegBuf::~CamRegBuf()
{
    
}

//Blocking method. Do not use during the running state!!
void CamRegBuf::SCCBWrite(uint8_t RegAddr, uint8_t Data)
{   
    m_sccbCtrl.lock();
    m_sccbCtrl.frequency(CAM_REG_I2CFREQ);
    
    m_sccbCtrl.start();
    
    m_sccbCtrl.write(m_writeAddr);
    wait_us(CAM_REG_WRITEWAIT);
    m_sccbCtrl.write(RegAddr);
    wait_us(CAM_REG_WRITEWAIT);
    m_sccbCtrl.write(Data);
    wait_us(CAM_REG_WRITEWAIT);
    
    m_sccbCtrl.stop();
    
    m_sccbCtrl.unlock();
}

//Blocking method. Do not use during the running state!!
uint8_t CamRegBuf::SCCBRead(const uint8_t RegAddr)
{
    m_sccbCtrl.lock();
    m_sccbCtrl.frequency(CAM_REG_I2CFREQ);
    
    m_sccbCtrl.start();
    
    m_sccbCtrl.write(m_writeAddr);
    wait_us(CAM_REG_WRITEWAIT);
    m_sccbCtrl.write(RegAddr);
    wait_us(CAM_REG_WRITEWAIT);   
    m_sccbCtrl.stop(); 
 
    m_sccbCtrl.start();
    m_sccbCtrl.write(m_readAddr);
    wait_us(CAM_REG_WRITEWAIT);
    char readValue = m_sccbCtrl.read(CAM_REG_NOACK);
    
    m_sccbCtrl.stop();
    
    m_sccbCtrl.unlock();
    
    return readValue;
}

/*
//Blocking method. Do not use during the running state!!
void CamRegBuf::ReadRegisters()
{
    for(int i = 0; i <= 0xff; ++i)
    {
        //char buf[10];
        //sprintf(buf, "%#x-%#x", i, SCCBRead(i));
        //m_core.GetUSBServer().PushUnreliableMsg('D', buf);
        
        wait(0.1);
    }
}

int32_t CamRegBuf::I2CBufferRead(int32_t ucDevAddr, uint8_t *ucBuffer, int32_t ulSize)
{
    m_sccbCtrl.start();       
    
    m_sccbCtrl.write(ucDevAddr);
    if(ulSize == 1){
        ucBuffer[0] = m_sccbCtrl.read(0);
    }else{  
        for(int i=0;i<ulSize;i++){
           ucBuffer[i] = m_sccbCtrl.read(0);
        }
    }    
    
    m_sccbCtrl.stop();

    return 0;
}
 
int32_t CamRegBuf::I2CBufferWrite(int32_t ucDevAddr, uint8_t *ucBuffer, int32_t ulSize)
{
    m_sccbCtrl.start();       
   
   // Set I2C slave write address
    m_sccbCtrl.write(ucDevAddr);
 
    if(ulSize == 1){
        m_sccbCtrl.write(ucBuffer[0]);
    }else{  
        for(int i=0;i<ulSize;i++){
           m_sccbCtrl.write(ucBuffer[i]);
        }
    }    
 
    m_sccbCtrl.stop();

    return 0;
} 
*/
void CamRegBuf::WriteRegSet(const struct sensor_reg * reglist)
{
    unsigned int i = 0;
    while ((reglist[i].reg != 0xff) | (reglist[i].val != 0xff))
    {
        SCCBWrite(reglist[i].reg, reglist[i].val);
        ++i;
        wait_ms(1);
    }
}