#include "mbed.h"

//#define SW_DEBUG
#include "SWCommon.h"
#include "GlobalVariable.h"
#include "PinAssignment.h"

#include "Motor.h"
#include "Servo.h"

#include "ArduCAM.h"
#include "ArduUTFT.h"
#include "ArduTouch.h"

#include "StateManager.h"


SPI g_spi_port(PIN_SPI_MOSI, PIN_SPI_MISO, PIN_SPI_SCK);

int main(void) {
    
    g_spi_port.frequency(5000000);
    
    motor_init();
    
    servo_init();
    
    wait(1.0f);
    
    ardu_utft_init();
    
    ardu_cam_init();
    
    ardu_touch_init();
    
    servo_set_angle(0.0f);
    
    state_manager_switch_state(STANDBY_STATE);
    
    while (1) 
    {
        state_manager_update(0.0f);
    }
}
