#include "TestingState.h"
#include "ArduCAM.h"
#include "ArduUTFT.h"
#include "CamRegBuf.h"
#include "StateManager.h"

TestingState::TestingState() : 
    m_shouldTerminate(0)
{}

TestingState::~TestingState()
{}

void TestingState::DrawUserInterface()
{
    ardu_utft_clr_scr();
    ardu_utft_print("Camera Version: ", 300, 80);
    
    ardu_utft_print("Camera PID: ", 300, 100);
    
    ardu_utft_print("ArduCam Version: ", 300, 120);
    
    ardu_utft_print("Screen Version: ", 300, 140);
    
    ardu_utft_print("Touch the screen anywhere to go back.", 300, 200);
}

void TestingState::Update(float deltaTime)
{
    if(m_shouldTerminate)
    {
        m_shouldTerminate = 0;
        state_manager_switch_state(STANDBY_STATE);
        return;
    }
    
    ardu_cam_display_img_utft();
    
    char buf[50];
    uint8_t temp;
    
    CamRegBuf * camReg = new CamRegBuf(CAM_SCCB_WRITE, CAM_SCCB_READ);
    
#if defined(ARDUCAM_OV2640)
    camReg->SCCBWrite(0xff, 0x01);
#endif
    
    temp = camReg->SCCBRead(CAM_VER_ADDR);
    sprintf(buf, "%#x", temp);
    ardu_utft_set_color(255, 255, 255);
    ardu_utft_print(buf, 150, 80);
    if(temp == CAM_VER_VALUE)
    {
        ardu_utft_set_color(0, 255, 0);
        ardu_utft_print("O", 100, 80);
    }
    else
    {
        ardu_utft_set_color(255, 0, 0);
        ardu_utft_print("X", 100, 80);
    }
    
    temp = camReg->SCCBRead(CAM_PID_ADDR);
    ardu_utft_set_color(255, 255, 255);
    sprintf(buf, "%#x", temp);
    ardu_utft_print(buf, 150, 100);
    if(temp == CAM_PID_VALUE)
    {
        ardu_utft_set_color(0, 255, 0);
        ardu_utft_print("O", 100, 100);
    }
    else
    {
        ardu_utft_set_color(255, 0, 0);
        ardu_utft_print("X", 100, 100);
    }
    
    delete camReg;
    camReg = NULL;
    
    
    
    temp = ardu_cam_get_ver_num();
    sprintf(buf, "%#x", temp);
    ardu_utft_set_color(255, 255, 255);
    ardu_utft_print(buf, 150, 120);
    if(temp == ARDUCHIP_VER_NUM)
    {
        ardu_utft_set_color(0, 255, 0);
        ardu_utft_print("O", 100, 120);
    }
    else
    {
        ardu_utft_set_color(255, 0, 0);
        ardu_utft_print("X", 100, 120);
    }
    temp = 0;
    temp = ardu_utft_get_ver_num();
    sprintf(buf, "%#x", temp);
    ardu_utft_set_color(255, 255, 255);
    ardu_utft_print(buf, 150, 140);
    if(temp == ARDUCHIP_VER_NUM_UTFT)
    {
        ardu_utft_set_color(0, 255, 0);
        ardu_utft_print("O", 100, 140);
    }
    else
    {
        ardu_utft_set_color(255, 0, 0);
        ardu_utft_print("X", 100, 140);
    }
}

uint8_t TestingState::HasTouchPosFunction() const
{
    return 0;
}

uint8_t TestingState::HasTouchIrqFunction() const
{
    return 1;
}

void TestingState::TouchIrqCallback()
{
    m_shouldTerminate = 1;
}