/**
 * @file StandbyState.h
 * @brief The header file for the StandbyState class.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef STANDBY_STATE_H
#define STANDBY_STATE_H

#include <mbed.h>
#include "States.h"

/**
 * @class StandbyState
 * @brief The class for standby state. It is a child class of the States class.
 * 
 */
class StandbyState : public States
{
public:
    /**
    * @brief This is the constructor for the StandbyState class
    * 
    */
    StandbyState();
    /**
    * @brief This is the destructor for the StandbyState class
    * 
    */
    ~StandbyState();
    
    /**
    * @brief Draw the user interface. This function is called only once, whenever the standby state becomes the current state.
    * 
    */
    virtual void DrawUserInterface();
    
    /**
    * @brief This functino will be called during every tick, only if the standby state is the current state. 
    * @param deltaTime The time interval between last tick and current tick.
    * 
    */
    virtual void Update(float deltaTime);
    
    /**
    * @brief Return wether or not the standby state has a position callback function for the touch screen.
    * @return 1 - yes. 
    * 
    */
    virtual uint8_t HasTouchPosFunction() const;
    
    /**
    * @brief Return wether or not the standby state has a interrupt callback function for the touch screen.
    * @return 0 - yes. 
    * 
    */
    virtual uint8_t HasTouchIrqFunction() const;
    
    /**
    * @brief The position callback function for the touch screen. Based on the touch position, the corresponding functionality will be executed. 
    * 
    */
    virtual void TouchPosCallback(int16_t x, int16_t y);
    
private:
    volatile int8_t m_nextState; /*!< @brief Pendding next state command. */
};

#endif //STANDBY_STATE_H