#include "StandbyState.h"

#include "ArduUTFT.h"

#include "StateManager.h"

StandbyState::StandbyState() : 
    m_nextState(STANDBY_STATE)
{}

StandbyState::~StandbyState()
{
    ardu_utft_print("X", 10, 10);
}

void StandbyState::DrawUserInterface()
{
    ardu_utft_clr_scr();
    
    ardu_utft_set_color(0, 0, 255);
    ardu_utft_fill_rect(10, 10, 310, 110);
    ardu_utft_set_color(255, 255, 255);
    ardu_utft_print("Run", 170, 50);
    
    ardu_utft_set_color(255, 255, 0);
    ardu_utft_fill_rect(10, 130, 310, 230);
    ardu_utft_set_color(255, 255, 255);
    ardu_utft_print("Test system", 200, 180);
}

void StandbyState::Update(float deltaTime)
{
    switch(m_nextState)
    {
    case RUNNING_STATE:
        m_nextState = STANDBY_STATE;
        state_manager_switch_state(RUNNING_STATE);
        return;
    case TESTING_STATE:
        m_nextState = STANDBY_STATE;
        state_manager_switch_state(TESTING_STATE);
        return;
    default:
        break;
    }
}

uint8_t StandbyState::HasTouchPosFunction() const
{
    return 1;
}

uint8_t StandbyState::HasTouchIrqFunction() const
{
    return 0;
}

void StandbyState::TouchPosCallback(int16_t x, int16_t y)
{
    if(y <= 110)
    {
        ardu_utft_print("X", x, y);
        m_nextState = RUNNING_STATE;
        
    }
    else if(y >= 130)
    {
        ardu_utft_print("X", x, y);
        m_nextState = TESTING_STATE;
    }
}
