/**
 * @file Servo.h
 * @brief The header file for the servo functions.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef SERVO_H
#define SERVO_H

#include <mbed.h>

#define SERVO_RT  1  /*!< @brief The sign for the right turn. */
#define SERVO_LF -1  /*!< @brief The sign for the left turn. */

#define SERVO_MAX_ANGLE 21.0f  /*!< @brief The max angle for turnning. */

#ifdef __cplusplus
extern "C" {
#endif

/**
* @brief Init the servo. There is only one servo in the system, thus, this function is required to be called only once during the system initialization.
*/
void servo_init();

/**
* @brief Set the angle of the servo.
* @param angle The angle in degrees. The sign determine the direction(left/right), and there is a max degree for turnning (They are defined above).
*/
void servo_set_angle(float angle);

#ifdef __cplusplus
}
#endif

#endif //SERVO_H