/**
 * @file OV2640RegProg.h
 * @brief The header file for all OV2640 register programs. Note: Part of the register program come from the ArduCam Arduino source code.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef OV2640_REG_PROG_H
#define OV2640_REG_PROG_H

#include "CamRegDefinitions.h"

#if defined(ARDUCAM_OV2640)

#define CAM_SCCB_WRITE      0x60 /*!< @brief SCCB slave write address for OV2640. */
#define CAM_SCCB_READ       0x61 /*!< @brief SCCB slave read address for OV2640. */

#define CAM_PID_VALUE        0x26 /*!< @brief PID value for the OV2640. */
#define CAM_VER_VALUE        0x42 /*!< @brief VER value for the OV2640. */

#define CAM_PID_ADDR      0x0A /*!< @brief Address that stores the PID value for the OV2640. */
#define CAM_VER_ADDR      0x0B /*!< @brief Address that stores the VER value for the OV2640. */

//namespace OV2640Prog
//{
    
const struct sensor_reg ResetProg[]  = /*!< @brief The register program used to reset the camera chip. */
{
    {0xff, 0x01},
    {0x12, 0x80},
    {0xff, 0xff},
};

#if (defined(RESOLUTION_WIDTH) && RESOLUTION_WIDTH == 800) && (defined(RESOLUTION_HEIGHT) && RESOLUTION_HEIGHT == 600)
const struct sensor_reg SVGA[]  = /*!< @brief The register program used to init the SVGA RGB565 output. */
{
    {0xff, 0x00},
    {0x2c, 0xff},
    {0x2e, 0xdf},
    {0xff, 0x01},
    {0x3c, 0x32},
//
    {0x11, 0x00},
    {0x09, 0x02},
    {0x04, 0x28},
    {0x13, 0xe5},
    {0x14, 0x48},

    {0x2c, 0x0c},
    {0x33, 0x78},
    {0x3a, 0x33},
    {0x3b, 0xfB},
//
    {0x3e, 0x00},
    {0x43, 0x11},
    {0x16, 0x10},
//
    {0x39, 0x92},
//
    {0x35, 0xda},
    {0x22, 0x1a},
    {0x37, 0xc3},
    {0x23, 0x00},
    {0x34, 0xc0},
    {0x36, 0x1a},
    {0x06, 0x88},
    {0x07, 0xc0},
    {0x0d, 0x87},
    {0x0e, 0x41},
    {0x4c, 0x00},
    {0x48, 0x00},
    {0x5B, 0x00},
    {0x42, 0x03},
//
    {0x4a, 0x81},
    {0x21, 0x99},
//
    {0x24, 0x40},
    {0x25, 0x38},
    {0x26, 0x82},
    {0x5c, 0x00},
    {0x63, 0x00},
    {0x46, 0x22},
    {0x0c, 0x3c},
//
    {0x61, 0x70},
    {0x62, 0x80},
    {0x7c, 0x05},
//
    {0x20, 0x80},
    {0x28, 0x30},
    {0x6c, 0x00},
    {0x6d, 0x80},
    {0x6e, 0x00},
    {0x70, 0x02},
    {0x71, 0x94},

    {0x73, 0xc1},
//
    {0x12, 0x40},
    {0x17, 0x11},
    {0x18, 0x43},
    {0x19, 0x00},
    {0x1a, 0x4b},
    {0x32, 0x09},
    {0x37, 0xc0},
    {0x4f, 0xca},
    {0x50, 0xa8},
    {0x5a, 0x23},
    {0x6d, 0x00},
    {0x3d, 0x38},
//
    {0xff, 0x00},
    {0xe5, 0x7f},
    {0xf9, 0xc0},
    {0x41, 0x24},
    {0xe0, 0x14},
    {0x76, 0xff},
    {0x33, 0xa0},
    {0x42, 0x20},
    {0x43, 0x18},
    {0x4c, 0x00},
    {0x87, 0xd5},
    {0x88, 0x3f},
    {0xd7, 0x03},
    {0xd9, 0x10},
    {0xd3, 0x82},
//
    {0xc8, 0x08},
    {0xc9, 0x80},
//
    {0x7c, 0x00},
    {0x7d, 0x00},
    {0x7c, 0x03},
    {0x7d, 0x48},
    {0x7d, 0x48},
    {0x7c, 0x08},
    {0x7d, 0x20},
    {0x7d, 0x10},
    {0x7d, 0x0e},
//
    {0x90, 0x00},
    {0x91, 0x0e},
    {0x91, 0x1a},
    {0x91, 0x31},

    {0x91, 0x5a},
    {0x91, 0x69},
    {0x91, 0x75},
    {0x91, 0x7e},
    {0x91, 0x88},
    {0x91, 0x8f},
    {0x91, 0x96},
    {0x91, 0xa3},
    {0x91, 0xaf},
    {0x91, 0xc4},
    {0x91, 0xd7},
    {0x91, 0xe8},
    {0x91, 0x20},
//
    {0x92, 0x00},
    {0x93, 0x06},
    {0x93, 0xe3},
    {0x93, 0x05},
    {0x93, 0x05},
    {0x93, 0x00},
    {0x93, 0x04},
    {0x93, 0x00},
    {0x93, 0x00},
    {0x93, 0x00},
    {0x93, 0x00},
    {0x93, 0x00},
    {0x93, 0x00},
    {0x93, 0x00},
//
    {0x96, 0x00},
    {0x97, 0x08},
    {0x97, 0x19},
    {0x97, 0x02},
    {0x97, 0x0c},
    {0x97, 0x24},
    {0x97, 0x30},
    {0x97, 0x28},
    {0x97, 0x26},
    {0x97, 0x02},
    {0x97, 0x98},
    {0x97, 0x80},
    {0x97, 0x00},
    {0x97, 0x00},
//
    {0xc3, 0xed},
    {0xa4, 0x00},
    {0xa8, 0x00},
    {0xc5, 0x11},

    {0xc6, 0x51},
    {0xbf, 0x80},
    {0xc7, 0x10},
    {0xb6, 0x66},
    {0xb8, 0xA5},
    {0xb7, 0x64},
    {0xb9, 0x7C},
    {0xb3, 0xaf},
    {0xb4, 0x97},
    {0xb5, 0xFF},
    {0xb0, 0xC5},
    {0xb1, 0x94},
    {0xb2, 0x0f},
    {0xc4, 0x5c},
//
    {0xc0, 0x64},
    {0xc1, 0x4B},
    {0x8c, 0x00},
    {0x86, 0x3D},
    {0x50, 0x00},
    {0x51, 0xC8},
    {0x52, 0x96},
    {0x53, 0x00},
    {0x54, 0x00},
    {0x55, 0x00},
    {0x5a, 0xC8},
    {0x5b, 0x96},
    {0x5c, 0x00},
    {0xd3, 0x82},
//
    {0xc3, 0xed},
    {0x7f, 0x00},
//
    {0xda, 0x08},
//
    {0xe5, 0x1f},
    {0xe1, 0x67},
    {0xe0, 0x00},
    {0xdd, 0x7f},
    {0x05, 0x00},
    
    {0xff, 0xff}
};
#endif // 800 X 600

//#if (defined(RESOLUTION_WIDTH) && RESOLUTION_WIDTH == 320) && (defined(RESOLUTION_HEIGHT) && RESOLUTION_HEIGHT == 240)
const struct sensor_reg QVGA[]  = /*!< @brief The register program used to init the VGA, QVGA, QQVGA in RGB565 output. */
{
    {0xff, 0x00}, //Bank 0
    {0x2c, 0xff}, 
    {0x2e, 0xdf}, 
    {0xff, 0x01}, //Bank 1
    {0x3c, 0x32}, 
    {0x11, 0x80}, /////////// //CLCK Speed
    {0x09, 0x02}, 
    {0x04, 0x68}, /////////// //Horizontal Mirror
    {0x13, 0xe5}, 
    {0x14, 0x48}, 
    {0x2c, 0x0c}, 
    {0x33, 0x78}, 
    {0x3a, 0x33}, 
    {0x3b, 0xfb}, 
    {0x3e, 0x00}, 
    {0x43, 0x11}, 
    {0x16, 0x10}, 
    {0x39, 0x02}, 
    {0x35, 0x88}, 

    {0x22, 0x0a}, 
    {0x37, 0x40}, 
    {0x23, 0x00}, 
    {0x34, 0xa0}, 
    {0x06, 0x02}, 
    {0x06, 0x88}, 
    {0x07, 0xc0}, 
    {0x0d, 0xb7}, 
    {0x0e, 0x01}, 
    {0x4c, 0x00}, 
    {0x4a, 0x81}, 
    {0x21, 0x99}, 
    {0x24, 0x40}, 
    {0x25, 0x38}, 
    {0x26, 0x82}, 
    {0x5c, 0x00}, 
    {0x63, 0x00}, 
    {0x46, 0x22}, 
    {0x0c, 0x3a}, 
    {0x5d, 0x55}, 
    {0x5e, 0x7d}, 
    {0x5f, 0x7d}, 
    {0x60, 0x55}, 
    {0x61, 0x70}, 
    {0x62, 0x80}, 
    {0x7c, 0x05}, 
    {0x20, 0x80}, 
    {0x28, 0x30}, 
    {0x6c, 0x00}, 
    {0x6d, 0x80}, 
    {0x6e, 0x00}, 
    {0x70, 0x02}, 
    {0x71, 0x94}, 
    {0x73, 0xc1}, 
    {0x3d, 0x34}, 
    {0x12, 0x04}, 
    {0x5a, 0x57}, 
    {0x4f, 0xbb}, 
    {0x50, 0x9c}, 
    {0xff, 0x00}, 
    {0xe5, 0x7f}, 
    {0xf9, 0xc0}, 
    {0x41, 0x24}, 
    {0xe0, 0x14}, 
    {0x76, 0xff}, 
    {0x33, 0xa0}, 
    {0x42, 0x20}, 
    {0x43, 0x18}, 
    {0x4c, 0x00}, 
    {0x87, 0xd0}, 
    {0x88, 0x3f}, 
    {0xd7, 0x03}, 
    {0xd9, 0x10}, 
    {0xd3, 0x82}, 
    {0xc8, 0x08}, 
    {0xc9, 0x80}, 
    {0x7c, 0x00}, 
    {0x7d, 0x00}, 
    {0x7c, 0x03}, 
    {0x7d, 0x48}, 
    {0x7d, 0x48}, 
    {0x7c, 0x08}, 
    {0x7d, 0x00}, //Gamma Correction?
    {0x7d, 0x10}, 
    {0x7d, 0x0e}, 
    {0x90, 0x00}, 
    {0x91, 0x0e}, 
    {0x91, 0x1a}, 
    {0x91, 0x31}, 
    {0x91, 0x5a}, 
    {0x91, 0x69}, 
    {0x91, 0x75}, 
    {0x91, 0x7e}, 
    {0x91, 0x88}, 
    {0x91, 0x8f}, 
    {0x91, 0x96}, 
    {0x91, 0xa3}, 
    {0x91, 0xaf}, 
    {0x91, 0xc4}, 
    {0x91, 0xd7}, 
    {0x91, 0xe8}, 
    {0x91, 0x20}, 
    {0x92, 0x00}, 

    {0x93, 0x06}, 
    {0x93, 0xe3}, 
    {0x93, 0x03}, 
    {0x93, 0x03}, 
    {0x93, 0x00}, 
    {0x93, 0x02}, 
    {0x93, 0x00}, 
    {0x93, 0x00}, 
    {0x93, 0x00}, 
    {0x93, 0x00}, 
    {0x93, 0x00}, 
    {0x93, 0x00}, 
    {0x93, 0x00}, 
    {0x96, 0x00}, 
    {0x97, 0x08}, 
    {0x97, 0x19}, 
    {0x97, 0x02}, 
    {0x97, 0x0c}, 
    {0x97, 0x24}, 
    {0x97, 0x30}, 
    {0x97, 0x28}, 
    {0x97, 0x26}, 
    {0x97, 0x02}, 
    {0x97, 0x98}, 
    {0x97, 0x80}, 
    {0x97, 0x00}, 
    {0x97, 0x00}, 
    {0xa4, 0x00}, 
    {0xa8, 0x00}, 
    {0xc5, 0x11}, 
    {0xc6, 0x51}, 
    {0xbf, 0x80}, 
    {0xc7, 0x10}, 
    {0xb6, 0x66}, 
    {0xb8, 0xa5}, 
    {0xb7, 0x64}, 
    {0xb9, 0x7c}, 
    {0xb3, 0xaf}, 
    {0xb4, 0x97}, 
    {0xb5, 0xff}, 
    {0xb0, 0xc5}, 
    {0xb1, 0x94}, 
    {0xb2, 0x0f}, 
    {0xc4, 0x5c}, 
    {0xa6, 0x00}, 
    {0xa7, 0x20}, 
    {0xa7, 0xd8}, 
    {0xa7, 0x1b}, 
    {0xa7, 0x31}, 
    {0xa7, 0x00}, 
    {0xa7, 0x18}, 
    {0xa7, 0x20}, 
    {0xa7, 0xd8}, 
    {0xa7, 0x19}, 
    {0xa7, 0x31}, 
    {0xa7, 0x00}, 
    {0xa7, 0x18}, 
    {0xa7, 0x20}, 
    {0xa7, 0xd8}, 
    {0xa7, 0x19}, 
    {0xa7, 0x31}, 
    {0xa7, 0x00}, 
    {0xa7, 0x18}, 
    {0x7f, 0x00}, 
    {0xe5, 0x1f}, 
    {0xe1, 0x77}, 
    {0xdd, 0x7f}, 
    {0xc2, 0x0e}, 
    
    {0xff, 0x00}, 
    {0xe0, 0x04}, 
    
    /////////////////
    {0x8c, 0x00}, 
    {0xc0, 0xc8}, 
    {0xc1, 0x96}, 
    /////////////////
    
    {0x86, 0x3d}, 
    
    /////////////////
    {0x51, 0x90}, 
    {0x52, 0x2c}, 
    {0x53, 0x00}, 
    {0x54, 0x00}, 
    {0x55, 0x88}, 
    {0x57, 0x00}, 
    ////////////////
    
#if (defined(RESOLUTION_WIDTH) && RESOLUTION_WIDTH == 320) && (defined(RESOLUTION_HEIGHT) && RESOLUTION_HEIGHT == 240)
    {0x50, 0x92}, 
    {0x5a, 0x50},  //Zoom
    {0x5b, 0x3C},  //Zoom
    {0x5c, 0x00},  //Zoom
#elif (defined(RESOLUTION_WIDTH) && RESOLUTION_WIDTH == 160) && (defined(RESOLUTION_HEIGHT) && RESOLUTION_HEIGHT == 120)
    {0x50, 0x92}, 
    {0x5a, 0x28},  //Zoom
    {0x5b, 0x1E},  //Zoom
    {0x5c, 0x00},  //Zoom
#elif (defined(RESOLUTION_WIDTH) && RESOLUTION_WIDTH == 80) && (defined(RESOLUTION_HEIGHT) && RESOLUTION_HEIGHT == 60)
    {0x50, 0xA4}, 
    {0x5a, 0x14},  //Zoom
    {0x5b, 0x0F},  //Zoom
    {0x5c, 0x00},  //Zoom
    
#else
    #error Must pick one valid resolution!!
#endif
    
    {0xd3, 0x04}, 
    {0xe0, 0x00}, 
    
    {0xff, 0x00}, 
    {0x05, 0x00}, 
    
    {0xda, 0x08}, 
    {0xd7, 0x03}, 
    {0xe0, 0x00}, 
    
    {0x05, 0x00}, 

    
    {0xff, 0xff},
};
//#endif //320 X 240

#endif //ARDUCAM_OV2640

#endif //OV2640_REG_PROG_H