/**
 * @file CamRegDefinitions.h
 * @brief The header file for the common definition that used for camera SCCB control.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef CAM_REG_DEFINITIONS_H
#define CAM_REG_DEFINITIONS_H

#define CAM_REG_WRITEWAIT    20     /*!< @brief The recommanded waiting time after a SCCB write behavior. In micro-sec. */
#define CAM_REG_NOACK        0      /*!< @brief The NOACK after a SCCB read behavior. */
#define CAM_REG_I2CFREQ      100000 /*!< @brief The recommanded frequency for camera SCCB communication. */

struct sensor_reg { /*!< @brief The struct used to store the register program. */
    uint8_t reg;    /*!< @brief The The Register Address. */
    uint8_t val;    /*!< @brief The The value that need to be written to the register in that address. */
};

#endif //CAM_REG_DEFINITIONS_H