/**
 * @file ArduTouch.h
 * @brief The header file for all functions that controls the ArduCam touch screen.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef ARDU_TOUCH_H
#define ARDU_TOUCH_H

#include <mbed.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
* @brief Init the touch screen. There is only one touch screen in the system, thus, this function is required to be called only once during the system initialization.
*/
void ardu_touch_init();

/**
* @brief Get the position of the most recent touch.
* @param x Output. Position in x-axis. A pointer points to the space used to store the value.
* @param y Output. Position in y-axis. A pointer points to the space used to store the value.
*/
void ardu_touch_get_pos(int16_t* x, int16_t* y);

/**
* @brief Set the touch screen interrupt callback function.
* @param irq_func The pointer to the interrupt callback function.
*/
void ardu_touch_set_irq_function(void(*irq_func)(void));

/**
* @brief Set the touch screen touch position callback function.
* @param pos_func The pointer to the touch position callback function.
*/
void ardu_touch_set_pos_function(void(*pos_func)(int16_t, int16_t));

#ifdef __cplusplus
}
#endif

#endif //ARDU_TOUCH_H