/**
 * @file GlobalVariable.h
 * @brief The header file for the global variable. Some object (ex. SPI port) can have only one instance, but it is used in many different place. Thus, these variables will be declare in this header file.
 * @author Jordan Brack <jabrack@mix.wvu.edu>, Haofan Zheng <hazheng@mix.wvu.edu>
 * 
 */
#pragma once
#ifndef GLOBAL_VARIABLE_H
#define GLOBAL_VARIABLE_H

#include <mbed.h>

extern SPI g_spi_port; /*!< @brief The SPI port connection. NOTE: This is a declaration of a extern variable. It is actually defined and initialized in main.cpp file. */

#endif //GLOBAL_VARIABLE_H