#ifndef IDLER__H
#define IDLER__H

#include "mbed.h"
#include "DrawingManager.h"

class Idler
{
    public:
        Idler(DigitalOut* pStatusLed, DrawingManager* pDrawingManager);
        static void tick();
        static void notIdle();
        static void displayStep();
        static void start();
        
    private:
        static DigitalOut* _pStatusLed;
        static bool _isRunning;
        static bool _isIdle;
        static unsigned int _stepCount;
        static DrawingManager* _pDrawingManager;
        static Ticker _idleTicker;
        static Timer _idleTimer;

};

#endif
