#ifndef LEDSTRIP__H
#define LEDSTRIP__H

// LED Strip using WS2801 with two ISRs for two SPI connected 
// LED strips running in parallel
// Rob Dobson 2013-2014

#include "mbed.h"

class ledstrip
{
    private:
        unsigned char* mpLedValuesA;
        unsigned char* mpLedValuesB;
        unsigned char* mpCurLedValues;
        int mLedsInStrip;
        int mSplitPoint;
        int mLedsBufSize;
        SPI* mpSPI0;
        SPI* mpSPI1;
        
    public:
        static const int mColoursPerLed = 3;

    public:
        ledstrip(int length, int splitPoint);
        ~ledstrip();
        unsigned char* GetBuffer();
        int GetBufferSizeinBytes();
        bool Resize(int length, int splitPoint);
        bool IsBusy();
        int GetNumLeds()
        {
            return mLedsInStrip;
        }
        void Clear();
        void RawFill(int startLed, int numLeds, const unsigned char* pLedVals);
        void HsvFill(int startLed, int numLeds, const unsigned char* pLedVals);
        void Fill(int startLed, int numLeds, 
                int r1, int g1, int b1, 
                int r2, int g2, int b2);
        void Fill(int startLed, int numLeds, 
                int r1, int g1, int b1);
        void ShowLeds();
        
};

#endif
