
#include "Idler.h"

DigitalOut* Idler::_pStatusLed = NULL;
bool Idler::_isRunning = false;
bool Idler::_isIdle = true;
unsigned int Idler::_stepCount = 0;
DrawingManager* Idler::_pDrawingManager = NULL;
Ticker Idler::_idleTicker;
Timer Idler::_idleTimer;

const int IDLE_TIMEOUT = 10; // N seconds of no REST commands -> idle

Idler::Idler(DigitalOut* pStatusLed, DrawingManager* pDrawingManager)
{
    _pStatusLed = pStatusLed;
    _pDrawingManager = pDrawingManager;
    _idleTicker.attach(&tick, 0.1);
}

void Idler::start()
{
    _isRunning = true;
}

void Idler::tick()
{
    // Check if we are running
    if (!_isRunning)
        return;
        
    // Check if idle
    if (!_isIdle)
    {
        // Check time since last notIdle
        if (_idleTimer.read() < IDLE_TIMEOUT)
            return;
        
        // Now idle again
        _idleTimer.stop();
        _isIdle = true;
    }

    // Blink LED
    *_pStatusLed = !(*_pStatusLed);
    
    // Step through display
    _pDrawingManager->DisplayIdle(_stepCount);
    _stepCount++;
}

void Idler::notIdle()
{
    _isIdle = false;
    *_pStatusLed = false;
    _idleTimer.reset();
    _idleTimer.start();
    _stepCount = 0;
}
