#ifndef DRAWING_MANAGER
#define DRAWING_MANAGER

//
// Drawing Manager for LightWall
// Rob Dobson 2015
//

#include "mbed.h"
#include "ledstrip.h"

class DrawingManager
{
public:
    DrawingManager();
    void Init(int numLeds, int splitPoint);
    void Clear();
    void RawFill(char* args, unsigned char* payload, int payloadLen, int payloadOffset);
    void Fill(char* args);
    void ShowLeds();
    void DisplayIdle(unsigned int stepCount);

private:
    ledstrip* pLedStrip;
    bool isBusy;
    int GetIntFromNameValPair(char* buf, char* name, int invalidVal);
    unsigned char pRawFillPayloadOverhang[2];
    int rawFillPayloadOverhangBytes;
};

#endif
