#ifndef COLOURCONVERTERS__H
#define COLOURCONVERTERS__H

typedef struct RgbColor
{
    unsigned char r;
    unsigned char g;
    unsigned char b;
    
    RgbColor(int inr, int ing, int inb)
    {
        r = (unsigned char) inr;
        g = (unsigned char) ing;
        b = (unsigned char) inb;
    }
} RgbColor;

typedef struct HsvColor
{
    unsigned char h;
    unsigned char s;
    unsigned char v;

    HsvColor(int inh, int ins, int inv)
    {
        h = (unsigned char) inh;
        s = (unsigned char) ins;
        v = (unsigned char) inv;
    }

} HsvColor;

void HsvToRgb(HsvColor hsv, RgbColor& rgb);

void RgbToHsv(RgbColor rgb, HsvColor& hsv);

#endif
