// SCARA_Arms library
// Code to compute the shoulder angles required to move a Dual-Arm SCARA robot to required x,y position
// More information at http://robdobson.com/scara-arm-calculations
// Copyright (C) Rob Dobson 2013-2015, MIT License

#ifndef SCARAARMS_H
#define SCARAARMS_H

// Description of a Dual-Arm SCARA robot
// The two arms of the robot are akin to two human arms with the hands permanently clasped together
// The arms are always in the same plane (generally horizontal) and the hands hold a stick (also in the same plane)
// On the end of the stick is the tool (pen/actuayor/nozzle/laser etc)

class ScaraArms
{
public:
    // Constructor
    // The measurements required to describe a Dual-Arm SCARA robot of the kind described above are:
    // 1) Distance between shoulders
    // 2) Distance from shoulder to elbow
    // 3) Distance from elbow to hand
    // 4) Distance from hand to tool (length of stick holding the tool)
    ScaraArms(double betweenShouldersMM, double shoulderToElbowMM, double elbowToHandMM, double handToToolMM);
    
    // Compute the angles at the shoulders given the required XY position of the tool in radians
    // Note that the way the angles are measured is that theta1 (the left arm angle) is measured counter-clockwise from 3 O'Clock
    // theta2 (the right arm angle) is measured clockwise from 9 O'Clock
    // To calculate both clockwise from 9 O'Clock use PI-theta2
    // To convert the angles to degrees multiply by 180/PI
    // The XY position has it's origin (0,0) at the left shoulder
    void ConvertXYtoScara(double x, double y, double &theta1, double &theta2);

    // Compute the XY position of the tool given the angles at the shoulders
    // See the comments above for the reverse calculation concerning the way the angles are measured and the origin 
    // of the XY coordinates
    // These calculations use a different mathematical model as the conversion in this direction is simpler and
    // it provides a useful cross check
    void ConvertScaratoXY(double theta1, double theta2, double &x, double &y);
    
private:
    double _betweenShouldersMM;
    double _shoulderToElbowMM;
    double _elbowToHandMM;
    double _handToToolMM;
};

#endif