// Detect stat of Volt-Alerter
// Device produces a square wave when voltage detected
// Cycle time of square wave around 100ms
// Rob Dobson, 2015

#include "VoltAlerter.h"

VoltAlerter::VoltAlerter(PinName pinName) :
    _inPin(pinName, PullUp)
{
    _curPinState = 0;
    _consecutiveLows = 0;
}

void VoltAlerter::Service()
{
    // Check pin
    if (!_inPin)
    {
        _curPinState = 1;
        _consecutiveLows = 0;
        return;
    }
    
    // Only set state low if we get X consecutive lows
    _consecutiveLows++;
    if (_consecutiveLows >= CONSECUTIVE_LOWS_REQD_FOR_LOW)
    {
        _curPinState = 0;
        // The following is just to ensure the int doesn't overflow
        _consecutiveLows = CONSECUTIVE_LOWS_REQD_FOR_LOW;
    }
}

