// Handles OneWire temperature sensors DB18S20
// Can handle multiple devices per pin
// Rob Dobson, 2015

#ifndef RdDS18B20__H
#define RdDS18B20__H

#include "mbed.h"
#include "Onewire.h"
#include "Logger.h"

class DS18B20
{
public:
    DS18B20(PinName mbedPin, Logger &logger);
    void ReqConvert();
    double ReadTemperature(int addrIdx);
    void DebugGetAddress(int addrIdx, char* buf);
    int SearchToGetAddresses();
    int GetNumAddresses()
    {
        return _numValidAddresses;
    }
    uint8_t* GetAddress(int addrIdx, uint8_t* addrBufPtr);
    char* GetAddressStr(int addrIdx);
    double GetLatestTemperature(int addrIdx, time_t& timeOfReading);
    
    static const int ONEWIRE_ADDR_STRLEN = 3 * ONEWIRE_ADDR_BYTES + 1;
    static const int MAX_BUS_DEVICES = 8;
    
    static const int INVALID_TEMPERATURE = -1000.0;
    
private:
    int _numValidAddresses;
    uint8_t _addrTable[MAX_BUS_DEVICES][ONEWIRE_ADDR_BYTES];
    double _temperatureTable[MAX_BUS_DEVICES];
    time_t _timeOfReadingTable[MAX_BUS_DEVICES];
    Onewire _oneWire;
    char _addrStr[ONEWIRE_ADDR_STRLEN];
    Logger &_logger;
    char* GetChipId(int val);

};

#endif