#ifndef __WATCHDOG__H
#define __WATCHDOG__H
#include "mbed.h"

// Simon's Watchdog code from
// http://mbed.org/forum/mbed/topic/508/
class Watchdog
{
    public:
        // Load timeout value in watchdog timer and enable
        void SetTimeoutSecs(float s)
        {
            LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
            uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
            LPC_WDT->WDTC = s * (float)clk;
            LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
            Feed();
        }
        // "kick" or "feed" the dog - reset the watchdog timer
        // by writing this required bit pattern
        void Feed() 
        {
            __disable_irq();
            LPC_WDT->WDFEED = 0xAA;
            LPC_WDT->WDFEED = 0x55;
            __enable_irq();
        }
        
        bool WatchdogCausedRestart()
        {
            if ((LPC_WDT->WDMOD >> 2) & 1)
                return true;
            return false;
        }
};

#endif
