// Log to SD
// Rob Dobson, 2015

#ifndef __LOGGER__H
#define __LOGGER__H
#include "mbed.h"
#include <stdarg.h>
#include "rtos.h"

class Logger
{
    public:
        Logger(const char* eventLogFileName, const char* dataLogFileBase, Mutex &sdCardMutex);
        void LogEvent(const char* format, ...);
        void LogData(const char* format, ...);
        void LogDebug(const char* format, ...);
        void SetDebugDest(bool logToFile, bool logToConsole)
        {
            _logDebugToFile = logToFile;
            _logDebugToConsole = logToConsole;
        };

    private:
        const char* _eventLogFileName;
        const char* _dataLogFileBase;
        bool _logDebugToFile;
        bool _logDebugToConsole;
        Mutex &_sdCardMutex;
};


#endif