// Detect stat of Volt-Alerter
// Device produces a square wave when voltage detected
// Cycle time of square wave around 100ms
// Rob Dobson, 2015

#ifndef __VOLTALERTER__H
#define __VOLTALERTER__H
#include "mbed.h"

class VoltAlerter
{
    public:
        VoltAlerter(PinName pinName);
        void Service();
        int GetState()
        {
            return _curPinState;
        };

        static const int CONSECUTIVE_LOWS_REQD_FOR_LOW = 10;
        
    private:
        DigitalIn _inPin;
        bool _curPinState;
        int _consecutiveLows;
};


#endif