// Handles Thermometers
// Rob Dobson, 2015

#ifndef Thermometers__H
#define Thermometers__H

#include "RdDS18B20.h"
#include "Logger.h"

struct TemperatureValue
{
    time_t timeStamp;
    char address[DS18B20::ONEWIRE_ADDR_STRLEN];
    double tempInCentigrade;
};

class Thermometers
{
public:
    Thermometers(int numTempSensorPins, const PinName tempSensorPins[], int serviceIntervalInMs, Logger &logger);
    void Init();
    void Service();
    int GetTemperatureValues(int maxTempValues, TemperatureValue* tempValues, int maxAgeInSecs);
    static const int numSecondsBetweenThermReadings = 10;
    static const int timeForThermReadingInSecs = 2;
    static const int reGetThermometerAddressesAfterNumReadings = 100;
    static const int MAX_ONEWIRE_BUSES = 1;
    static const int MAX_THERMOMETERS = 8;
    
private:
    // Thermometer info
    int _numTempSensorPins;
    const PinName* _tempSensorPins;
    int _numThermometerBuses;
    DS18B20* _thermometerBuses[MAX_ONEWIRE_BUSES];
    int _serviceIntervalInMs;

    // Counters for state machine
    int _countForThermReadings;
    int _countForGetThermometerAddresses;
    
    // DEBUG
    int _failReadCount;
    int _failAddrCount;
    Logger &_logger;
};

#endif
