#ifndef __PULSEPIN__H
#define __PULSEPIN__H
#include "mbed.h"

class PulsePin
{
    public:
        PulsePin(DigitalIn& pin, bool risingEdge, int pinStableTimeMs);
        bool Service();
        int GetPulseRateMs();
        int GetPulseCount();
        void SetPulseCount(int pulseCount);

    private:
        DigitalIn& _pin;
        Timer _pinTimer;
        bool _curPinState;
        bool _firstEdgeDetected;
        int _lastStableTimeMs;
        int _waitForPinStabilisationMs;
        bool _detectRisingEdge;
        int _timeBetweenEdgesMs;
        int _pulseCount;
        int _pinTimerMinutes;
};


#endif