#ifndef __GASUSECOUNTER__H
#define __GASUSECOUNTER__H
#include "mbed.h"
#include "PulsePin.h"
#include "SDFileSystem.h"
#include "Logger.h"

const int MAX_GAS_COUNT_STR_LEN = 50;
const int MAX_PULSES_BEFORE_STORE_NV = 1; // Store at each pulse

class GasUseCounter
{
    public:
        // Constructor
        GasUseCounter(const char* gasUseFilename1, const char* gasUseFilename2, DigitalIn& gasPulsePin, Logger &logger, Mutex &sdCardMutex) :
                _gasPulsePin(gasPulsePin), _logger(logger), _sdCardMutex(sdCardMutex)
        {
            _gasUseFilename1 = gasUseFilename1;
            _gasUseFilename2 = gasUseFilename2;
            _lastWrittenGasCount = 0;
            _pulseDetector = new PulsePin(_gasPulsePin, false, 200);
        }
        
        // Init (get count from NV)
        void Init();
        
        // Callback from web server to handle getting current gas count
        char* getGasUseCallback(char* cmdStr, char* argStr);

        // Service function to detect pulses
        bool Service();
        
        // Read/Write current gas count
        void GetGasCountFromSD();
        void WriteGasCountToSD();
        
        // Get Count
        int GetCount()
        {
            return _pulseDetector->GetPulseCount();
        }
        
        // Set Count
        void SetCount(int gasUseCount)
        {
            _pulseDetector->SetPulseCount(gasUseCount);
            WriteGasCountToSD();
        }
        
        // Get inter-pulse time
        int GetPulseRateMs()
        {
            return _pulseDetector->GetPulseRateMs();
        }
        
    private:
        // Gas use filename for non-volatile
        const char* _gasUseFilename1;
        const char* _gasUseFilename2;
        int _curGasCount;
        int _lastWrittenGasCount;
        char _gasCountStr [MAX_GAS_COUNT_STR_LEN];
        DigitalIn& _gasPulsePin;
        PulsePin* _pulseDetector;
        Logger &_logger;
        Mutex &_sdCardMutex;
};




#endif
